/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.nio.LocalSession;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalFindFeature
implements Find {
    private static final Logger log = LogManager.getLogger(LocalFindFeature.class);
    private final LocalSession session;

    public LocalFindFeature(LocalSession session) {
        this.session = session;
    }

    public boolean find(Path file, ListProgressListener listener) throws BackgroundException {
        if (Files.isSymbolicLink(this.session.toPath(file))) {
            return Files.exists(this.session.toPath(file), LinkOption.NOFOLLOW_LINKS);
        }
        boolean exists = this.session.toPath(file).toFile().exists();
        if (exists && !file.isRoot()) {
            try {
                if (!StringUtils.equals((CharSequence)this.session.toPath(file).toFile().getCanonicalFile().getName(), (CharSequence)file.getName())) {
                    return false;
                }
            }
            catch (IOException e) {
                log.warn(String.format("Failure obtaining canonical file reference for %s", file));
            }
        }
        return exists;
    }
}

