/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.storegate.StoregateApiClient;
import ch.cyberduck.core.storegate.StoregateAttributesFinderFeature;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.JSON;
import ch.cyberduck.core.storegate.io.swagger.client.model.FileMetadata;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

public class StoregateWriteFeature
extends AbstractHttpWriteFeature<FileMetadata> {
    private static final Logger log = LogManager.getLogger(StoregateWriteFeature.class);
    private final StoregateSession session;
    private final StoregateIdProvider fileid;

    public StoregateWriteFeature(StoregateSession session, StoregateIdProvider fileid) {
        super((AttributesAdapter)new StoregateAttributesFinderFeature(session, fileid));
        this.session = session;
        this.fileid = fileid;
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }

    public boolean timestamp() {
        return true;
    }

    public HttpResponseOutputStream<FileMetadata> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        DelayedHttpEntityCallable<FileMetadata> command = new DelayedHttpEntityCallable<FileMetadata>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public FileMetadata call(AbstractHttpEntity entity) throws BackgroundException {
                String location;
                try {
                    location = StoregateWriteFeature.this.start(file, status);
                }
                catch (InteroperabilityException e) {
                    if (null == status.getLockId()) {
                        throw e;
                    }
                    location = StoregateWriteFeature.this.start(file, status.withLockId(null));
                }
                StoregateApiClient client = (StoregateApiClient)StoregateWriteFeature.this.session.getClient();
                try {
                    String header;
                    HttpPut put = new HttpPut(location);
                    put.setEntity((HttpEntity)entity);
                    if (status.getLength() == 0L) {
                        header = "*/0";
                    } else {
                        HttpRange range = HttpRange.byLength((long)0L, (long)status.getLength());
                        header = String.format("%d-%d/%d", range.getStart(), range.getEnd(), status.getLength());
                    }
                    put.addHeader("Content-Range", String.format("bytes %s", header));
                    CloseableHttpResponse putResponse = client.getClient().execute((HttpUriRequest)put);
                    try {
                        switch (putResponse.getStatusLine().getStatusCode()) {
                            case 200: 
                            case 201: {
                                FileMetadata result = (FileMetadata)new JSON().getContext(FileMetadata.class).readValue((Reader)new InputStreamReader(putResponse.getEntity().getContent(), StandardCharsets.UTF_8), FileMetadata.class);
                                StoregateWriteFeature.this.fileid.cache(file, result.getId());
                                FileMetadata fileMetadata = result;
                                return fileMetadata;
                            }
                        }
                        throw new StoregateExceptionMappingService(StoregateWriteFeature.this.fileid).map(new ApiException(putResponse.getStatusLine().getStatusCode(), putResponse.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)putResponse.getEntity())));
                    }
                    catch (BackgroundException e) {
                        StoregateWriteFeature.this.cancel(file, location);
                        throw e;
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)putResponse.getEntity());
                    }
                }
                catch (IOException e) {
                    StoregateWriteFeature.this.cancel(file, location);
                    throw new HttpExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
                }
            }

            public long getContentLength() {
                return status.getLength();
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected String start(Path file, TransferStatus status) throws BackgroundException {
        try {
            client = (StoregateApiClient)this.session.getClient();
            request = new HttpPost(String.format("%s/v4/upload/resumable", new Object[]{client.getBasePath()}));
            meta = new FileMetadata();
            meta.setId("");
            if (status.isHidden()) {
                meta.setAttributes(2);
            } else {
                meta.setAttributes(0);
            }
            meta.setFlags(0);
            if (status.getLockId() != null) {
                request.addHeader("X-Lock-Id", status.getLockId().toString());
            }
            meta.setFileName(URIEncoder.encode((String)file.getName()));
            meta.setParentId(this.fileid.getFileId(file.getParent(), (ListProgressListener)new DisabledListProgressListener()));
            meta.setFileSize(status.getLength() > 0L ? Long.valueOf(status.getLength()) : null);
            meta.setCreated(DateTime.now());
            if (null != status.getTimestamp()) {
                meta.setModified(new DateTime((Object)status.getTimestamp()));
            }
            request.setEntity((HttpEntity)new StringEntity(new JSON().getContext(meta.getClass()).writeValueAsString((Object)meta), ContentType.create((String)"application/json", (String)StandardCharsets.UTF_8.name())));
            request.addHeader("Content-Type", "application/json; charset=UTF-8");
            response = client.getClient().execute((HttpUriRequest)request);
            try {
                switch (response.getStatusLine().getStatusCode()) {
                    case 200: {
                        ** break;
lbl26:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new StoregateExceptionMappingService(this.fileid).map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                    }
                }
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            if (response.containsHeader("Location")) {
                return response.getFirstHeader("Location").getValue();
            }
            throw new StoregateExceptionMappingService(this.fileid).map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
    }

    protected void cancel(Path file, String location) throws BackgroundException {
        log.warn(String.format("Cancel failed upload %s for %s", location, file));
        try {
            HttpDelete delete = new HttpDelete(location);
            ((StoregateApiClient)this.session.getClient()).getClient().execute((HttpUriRequest)delete);
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
    }
}

