/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.StoregateWriteFeature;
import ch.cyberduck.core.storegate.io.swagger.client.model.FileMetadata;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;

public class StoregateTouchFeature
implements Touch<FileMetadata> {
    private Write<FileMetadata> writer;

    public StoregateTouchFeature(StoregateSession session, StoregateIdProvider fileid) {
        this.writer = new StoregateWriteFeature(session, fileid);
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        try {
            StatusOutputStream out = this.writer.write(file, status, (ConnectionCallback)new DisabledConnectionCallback());
            out.close();
            return file.withAttributes(status.getResponse());
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot create {0}", (Throwable)e, file);
        }
    }

    public Touch<FileMetadata> withWriter(Write<FileMetadata> writer) {
        this.writer = writer;
        return this;
    }

    public boolean isSupported(Path workdir, String filename) {
        return !workdir.isRoot();
    }
}

