/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.api.AccountSettingsApi;
import ch.cyberduck.core.storegate.io.swagger.client.model.AccountStorage;

public class StoregateQuotaFeature
implements Quota {
    private final StoregateSession session;
    private final StoregateIdProvider fileid;

    public StoregateQuotaFeature(StoregateSession session, StoregateIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Quota.Space get() throws BackgroundException {
        try {
            AccountSettingsApi account = new AccountSettingsApi((ApiClient)this.session.getClient());
            AccountStorage quota = account.accountSettingsGetAccountStorage();
            return new Quota.Space(quota.getUsed(), quota.getAvailable());
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService(this.fileid).map("Failure to read attributes of {0}", e, new DefaultHomeFinderService((Session)this.session).find());
        }
    }
}

