/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.storegate.StoregateApiClient;
import ch.cyberduck.core.storegate.StoregateAttributesFinderFeature;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.StoregateWriteFeature;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.JSON;
import ch.cyberduck.core.storegate.io.swagger.client.model.FileMetadata;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StoregateMultipartWriteFeature
implements MultipartWrite<FileMetadata> {
    private static final Logger log = LogManager.getLogger(StoregateMultipartWriteFeature.class);
    private final StoregateSession session;
    private final StoregateIdProvider fileid;

    public StoregateMultipartWriteFeature(StoregateSession session, StoregateIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }

    public HttpResponseOutputStream<FileMetadata> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        String location = new StoregateWriteFeature(this.session, this.fileid).start(file, status);
        final MultipartOutputStream proxy = new MultipartOutputStream(location, file, status);
        return new HttpResponseOutputStream<FileMetadata>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, Integer.valueOf(new HostPreferences(this.session.getHost()).getInteger("storegate.upload.multipart.chunksize"))), (AttributesAdapter)new StoregateAttributesFinderFeature(this.session, this.fileid), status){

            public FileMetadata getStatus() {
                return proxy.getResult();
            }
        };
    }

    private final class MultipartOutputStream
    extends OutputStream {
        private final String location;
        private final Path file;
        private final TransferStatus overall;
        private final AtomicBoolean close = new AtomicBoolean();
        private final AtomicReference<BackgroundException> canceled = new AtomicReference();
        private final AtomicReference<FileMetadata> result = new AtomicReference();
        private Long offset = 0L;
        private final Long length;

        public MultipartOutputStream(String location, Path file, TransferStatus status) {
            this.location = location;
            this.file = file;
            this.overall = status;
            this.length = status.getOffset() + status.getLength();
        }

        @Override
        public void write(int value) throws IOException {
            throw new IOException(new UnsupportedOperationException());
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                if (null != this.canceled.get()) {
                    throw this.canceled.get();
                }
                final byte[] content = Arrays.copyOfRange(b, off, len);
                new DefaultRetryCallable(StoregateMultipartWriteFeature.this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<Void>(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public Void call() throws BackgroundException {
                        StoregateApiClient client = (StoregateApiClient)StoregateMultipartWriteFeature.this.session.getClient();
                        try {
                            HttpEntity entity = EntityBuilder.create().setBinary(content).build();
                            HttpPut put = new HttpPut(MultipartOutputStream.this.location);
                            put.setEntity(entity);
                            if (0L != MultipartOutputStream.this.overall.getLength() && 0 != content.length) {
                                HttpRange range = HttpRange.byLength((long)MultipartOutputStream.this.offset, (long)content.length);
                                String header = MultipartOutputStream.this.overall.getLength() == -1L ? String.format("%d-%d/*", range.getStart(), range.getEnd()) : String.format("%d-%d/%d", range.getStart(), range.getEnd(), MultipartOutputStream.this.length);
                                put.addHeader("Content-Range", String.format("bytes %s", header));
                            }
                            CloseableHttpResponse response = client.getClient().execute((HttpUriRequest)put);
                            try {
                                switch (response.getStatusLine().getStatusCode()) {
                                    case 200: 
                                    case 201: {
                                        FileMetadata metadata = (FileMetadata)new JSON().getContext(FileMetadata.class).readValue((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8), FileMetadata.class);
                                        MultipartOutputStream.this.result.set(metadata);
                                        StoregateMultipartWriteFeature.this.fileid.cache(MultipartOutputStream.this.file, metadata.getId());
                                    }
                                    case 204: {
                                        MultipartOutputStream.this.offset = MultipartOutputStream.this.offset + (long)content.length;
                                        return null;
                                    }
                                    default: {
                                        ApiException failure = new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity()));
                                        throw new StoregateExceptionMappingService(StoregateMultipartWriteFeature.this.fileid).map("Upload {0} failed", failure, MultipartOutputStream.this.file);
                                    }
                                }
                            }
                            catch (BackgroundException e) {
                                new StoregateWriteFeature(StoregateMultipartWriteFeature.this.session, StoregateMultipartWriteFeature.this.fileid).cancel(MultipartOutputStream.this.file, MultipartOutputStream.this.location);
                                MultipartOutputStream.this.canceled.set(e);
                                throw e;
                            }
                            finally {
                                EntityUtils.consume((HttpEntity)response.getEntity());
                            }
                        }
                        catch (IOException e) {
                            throw new DefaultIOExceptionMappingService().map(e);
                        }
                    }
                }, (StreamCancelation)this.overall).call();
            }
            catch (BackgroundException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void close() throws IOException {
            try {
                if (this.close.get()) {
                    log.warn(String.format("Skip double close of stream %s", this));
                    return;
                }
                if (null != this.canceled.get()) {
                    log.warn(String.format("Skip closing with previous failure %s", new Object[]{this.canceled.get()}));
                    return;
                }
                if (this.overall.getLength() > 0L) return;
                StoregateApiClient client = (StoregateApiClient)StoregateMultipartWriteFeature.this.session.getClient();
                HttpPut put = new HttpPut(this.location);
                put.addHeader("Content-Range", "bytes */0");
                CloseableHttpResponse response = client.getClient().execute((HttpUriRequest)put);
                try {
                    switch (response.getStatusLine().getStatusCode()) {
                        case 200: 
                        case 201: {
                            FileMetadata metadata = (FileMetadata)new JSON().getContext(FileMetadata.class).readValue((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8), FileMetadata.class);
                            this.result.set(metadata);
                            StoregateMultipartWriteFeature.this.fileid.cache(this.file, metadata.getId());
                        }
                        case 204: {
                            return;
                        }
                        default: {
                            ApiException failure = new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity()));
                            throw new StoregateExceptionMappingService(StoregateMultipartWriteFeature.this.fileid).map("Upload {0} failed", failure, this.file);
                        }
                    }
                }
                catch (BackgroundException e) {
                    throw new IOException(e);
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            finally {
                this.close.set(true);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MultipartOutputStream{");
            sb.append("id='").append(this.location).append('\'');
            sb.append(", file=").append(this.file);
            sb.append('}');
            return sb.toString();
        }

        public FileMetadata getResult() {
            return this.result.get();
        }
    }
}

