/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.storegate.StoregateAttributesFinderFeature;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.storegate.io.swagger.client.model.File;
import ch.cyberduck.core.storegate.io.swagger.client.model.FileContents;
import ch.cyberduck.core.storegate.io.swagger.client.model.RootFolder;
import java.util.EnumSet;

public class StoregateListService
implements ListService {
    private final StoregateSession session;
    private final StoregateIdProvider fileid;
    private final int chunksize;

    public StoregateListService(StoregateSession session, StoregateIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
        this.chunksize = new HostPreferences(session.getHost()).getInteger("storegate.listing.chunksize");
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        if (directory.isRoot()) {
            AttributedList list = new AttributedList();
            for (RootFolder root : this.session.roots()) {
                switch (root.getRootFolderType()) {
                    case 0: 
                    case 1: {
                        PathAttributes attr = new PathAttributes().withFileId(root.getId());
                        attr.setModificationDate(root.getModified().getMillis());
                        attr.setCreationDate(root.getCreated().getMillis());
                        list.add((Referenceable)new Path(directory, PathNormalizer.name((String)root.getName()), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume), attr));
                    }
                }
            }
            listener.chunk(directory, list);
            return list;
        }
        try {
            FileContents files;
            AttributedList children = new AttributedList();
            StoregateAttributesFinderFeature attributes = new StoregateAttributesFinderFeature(this.session, this.fileid);
            int pageIndex = 0;
            int fileCount = 0;
            do {
                files = new FilesApi((ApiClient)this.session.getClient()).filesGet(URIEncoder.encode((String)this.fileid.getPrefixedPath(directory)), pageIndex, this.chunksize, "Name asc", 0, true, false, false);
                for (File f : files.getFiles()) {
                    PathAttributes attrs = attributes.toAttributes(f);
                    EnumSet<AbstractPath.Type> type = (f.getFlags() & 1) == 1 ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file);
                    children.add((Referenceable)new Path(directory, f.getName(), type, attrs));
                    listener.chunk(directory, children);
                }
                ++pageIndex;
            } while ((fileCount += files.getFiles().size()) < files.getTotalRowCount());
            return children;
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService(this.fileid).map("Listing directory {0} failed", e, directory);
        }
    }
}

