/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.CachingFileIdProvider;
import ch.cyberduck.core.DefaultPathContainerService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathRelativizer;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.FileIdProvider;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.storegate.io.swagger.client.model.RootFolder;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StoregateIdProvider
extends CachingFileIdProvider
implements FileIdProvider {
    private static final Logger log = LogManager.getLogger(StoregateIdProvider.class);
    private final StoregateSession session;

    public StoregateIdProvider(StoregateSession session) {
        super(session.getCaseSensitivity());
        this.session = session;
    }

    public String getFileId(Path file, ListProgressListener listener) throws BackgroundException {
        try {
            if (StringUtils.isNotBlank((CharSequence)file.attributes().getFileId())) {
                return file.attributes().getFileId();
            }
            String cached = super.getFileId(file, listener);
            if (cached != null) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Return cached fileid %s for file %s", cached, file));
                }
                return cached;
            }
            String id = new FilesApi((ApiClient)this.session.getClient()).filesGet_1(URIEncoder.encode((String)this.getPrefixedPath(file))).getId();
            this.cache(file, id);
            return id;
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService(this).map("Failure to read attributes of {0}", e, file);
        }
    }

    protected String getPrefixedPath(Path file) {
        DefaultPathContainerService service = new DefaultPathContainerService();
        String root = service.getContainer(file).getAbsolute();
        for (RootFolder r : this.session.roots()) {
            if (!root.endsWith(r.getName())) continue;
            if (service.isContainer(file)) {
                return r.getPath();
            }
            return String.format("%s/%s", r.getPath(), PathRelativizer.relativize((String)root, (String)file.getAbsolute()));
        }
        return file.getAbsolute();
    }
}

