/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.storegate.StoregateAttributesFinderFeature;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.storegate.io.swagger.client.model.CreateFolderRequest;
import ch.cyberduck.core.storegate.io.swagger.client.model.File;
import ch.cyberduck.core.transfer.TransferStatus;

public class StoregateDirectoryFeature
implements Directory<VersionId> {
    private final StoregateSession session;
    private final StoregateIdProvider fileid;

    public StoregateDirectoryFeature(StoregateSession session, StoregateIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Path mkdir(Path folder, TransferStatus status) throws BackgroundException {
        try {
            FilesApi files = new FilesApi((ApiClient)this.session.getClient());
            CreateFolderRequest request = new CreateFolderRequest();
            request.setName(folder.getName());
            request.setParentID(this.fileid.getFileId(folder.getParent(), (ListProgressListener)new DisabledListProgressListener()));
            File f = files.filesCreateFolder(request);
            this.fileid.cache(folder, f.getId());
            return folder.withAttributes(new StoregateAttributesFinderFeature(this.session, this.fileid).toAttributes(f));
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService(this.fileid).map("Cannot create folder {0}", e, folder);
        }
    }

    public Directory<VersionId> withWriter(Write<VersionId> writer) {
        return this;
    }

    public boolean isSupported(Path workdir, String name) {
        return !workdir.isRoot();
    }
}

