/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.storegate.io.swagger.client.model.File;
import ch.cyberduck.core.storegate.io.swagger.client.model.FileMetadata;

public class StoregateAttributesFinderFeature
implements AttributesFinder,
AttributesAdapter<FileMetadata> {
    private final StoregateSession session;
    private final StoregateIdProvider fileid;

    public StoregateAttributesFinderFeature(StoregateSession session, StoregateIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public PathAttributes find(Path file, ListProgressListener listener) throws BackgroundException {
        try {
            FilesApi files = new FilesApi((ApiClient)this.session.getClient());
            return this.toAttributes(files.filesGet_1(URIEncoder.encode((String)this.fileid.getPrefixedPath(file))));
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService(this.fileid).map("Failure to read attributes of {0}", e, file);
        }
    }

    protected PathAttributes toAttributes(File f) {
        PathAttributes attrs = new PathAttributes();
        if (0L != f.getModified().getMillis()) {
            attrs.setModificationDate(f.getModified().getMillis());
        } else {
            attrs.setModificationDate(f.getUploaded().getMillis());
        }
        if (0L != f.getCreated().getMillis()) {
            attrs.setCreationDate(f.getCreated().getMillis());
        } else {
            attrs.setCreationDate(f.getUploaded().getMillis());
        }
        attrs.setSize(f.getSize().longValue());
        if ((f.getFlags() & 4) == 4) {
            attrs.setLockId(Boolean.TRUE.toString());
        }
        if ((f.getFlags() & 0x200) == 512) {
            attrs.setHidden(true);
        }
        Permission permission = (f.getPermission() & 2) == 2 || (f.getPermission() & 4) == 4 ? new Permission(Permission.Action.read_write, Permission.Action.none, Permission.Action.none) : new Permission(Permission.Action.read, Permission.Action.none, Permission.Action.none);
        if ((f.getFlags() & 1) == 1) {
            permission.setUser(permission.getUser().or(Permission.Action.execute));
        }
        attrs.setPermission(permission);
        attrs.setFileId(f.getId());
        return attrs;
    }

    public PathAttributes toAttributes(FileMetadata f) {
        PathAttributes attrs = new PathAttributes();
        if (0L != f.getModified().getMillis()) {
            attrs.setModificationDate(f.getModified().getMillis());
        }
        if (0L != f.getCreated().getMillis()) {
            attrs.setCreationDate(f.getCreated().getMillis());
        }
        attrs.setSize(f.getFileSize().longValue());
        if ((f.getFlags() & 4) == 4) {
            attrs.setLockId(Boolean.TRUE.toString());
        }
        if ((f.getFlags() & 0x200) == 512) {
            attrs.setHidden(true);
        }
        attrs.setFileId(f.getId());
        return attrs;
    }
}

