/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.rpc;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.security.auth.Subject;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.rpc.OncRpcProgram;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.dcache.oncrpc4j.rpc.RpcDispatchable;
import org.dcache.oncrpc4j.rpc.RpcException;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcDispatcher
extends BaseFilter {
    private static final Logger _log = LoggerFactory.getLogger(RpcDispatcher.class);
    private final Map<OncRpcProgram, RpcDispatchable> _programs;
    private final ExecutorService _asyncExecutorService;
    private final boolean _withSubjectPropagation;

    public RpcDispatcher(ExecutorService executor, Map<OncRpcProgram, RpcDispatchable> programs, boolean withSubjectPropagation) throws NullPointerException {
        this._programs = Objects.requireNonNull(programs, "Programs is NULL");
        this._asyncExecutorService = Objects.requireNonNull(executor, "ExecutorService is NULL");
        this._withSubjectPropagation = withSubjectPropagation;
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        final RpcCall call = (RpcCall)ctx.getMessage();
        int prog = call.getProgram();
        int vers = call.getProgramVersion();
        int proc = call.getProcedure();
        _log.debug("processing request {}", (Object)call);
        final RpcDispatchable program = this._programs.get(new OncRpcProgram(prog, vers));
        if (program == null) {
            call.failProgramUnavailable();
        } else {
            this._asyncExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    block8: {
                        try {
                            if (RpcDispatcher.this._withSubjectPropagation) {
                                Subject subject = call.getCredential().getSubject();
                                try {
                                    Subject.doAs(subject, () -> {
                                        program.dispatchOncRpcCall(call);
                                        return null;
                                    });
                                    break block8;
                                }
                                catch (PrivilegedActionException e) {
                                    Throwable t = e.getCause();
                                    Throwables.throwIfInstanceOf((Throwable)t, IOException.class);
                                    Throwables.throwIfUnchecked((Throwable)t);
                                    throw new RuntimeException("Unexpected exception", e);
                                }
                            }
                            program.dispatchOncRpcCall(call);
                        }
                        catch (RpcException e) {
                            call.reject(e.getStatus(), e.getRpcReply());
                            _log.warn("Failed to process RPC request: {}", (Object)e.getMessage());
                        }
                        catch (OncRpcException e) {
                            call.failRpcGarbage();
                            _log.warn("Failed to process RPC request: {}", (Object)e.getMessage());
                        }
                        catch (IOException e) {
                            call.failRpcGarbage();
                            _log.warn("Failed to process RPC request: {}", (Object)e.getMessage());
                        }
                        catch (RuntimeException e) {
                            _log.error("Failed to process RPC request:", (Throwable)e);
                            call.failRpcSystem();
                            throw e;
                        }
                    }
                }

                public String toString() {
                    return call.toString();
                }
            });
        }
        return ctx.getInvokeAction();
    }
}

