/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.rpc;

import java.io.IOException;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.rpc.RpcAuth;
import org.dcache.oncrpc4j.rpc.RpcAuthError;
import org.dcache.oncrpc4j.rpc.RpcAuthException;
import org.dcache.oncrpc4j.rpc.RpcAuthTypeNone;
import org.dcache.oncrpc4j.rpc.RpcAuthTypeTls;
import org.dcache.oncrpc4j.rpc.RpcAuthTypeUnix;
import org.dcache.oncrpc4j.rpc.RpcTransport;
import org.dcache.oncrpc4j.rpc.gss.RpcAuthGss;
import org.dcache.oncrpc4j.xdr.XdrDecodingStream;

public class RpcCredential {
    private RpcCredential() {
    }

    public static RpcAuth decode(XdrDecodingStream xdr, RpcTransport transport) throws OncRpcException, IOException {
        RpcAuth credential;
        int authType = xdr.xdrDecodeInt();
        switch (authType) {
            case 1: {
                credential = new RpcAuthTypeUnix();
                break;
            }
            case 0: {
                credential = new RpcAuthTypeNone();
                break;
            }
            case 6: {
                credential = new RpcAuthGss();
                break;
            }
            case 7: {
                credential = new RpcAuthTypeTls();
                transport.startTLS();
                break;
            }
            default: {
                throw new RpcAuthException("Unsuported type: " + authType, new RpcAuthError(7));
            }
        }
        credential.xdrDecode(xdr);
        return credential;
    }
}

