/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.rpc;

import com.google.common.base.Preconditions;
import com.sun.security.auth.UnixNumericGroupPrincipal;
import com.sun.security.auth.UnixNumericUserPrincipal;
import com.sun.security.auth.module.UnixSystem;
import java.io.IOException;
import java.net.InetAddress;
import java.security.Principal;
import java.time.Instant;
import java.util.Arrays;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.rpc.RpcAuth;
import org.dcache.oncrpc4j.rpc.RpcAuthVerifier;
import org.dcache.oncrpc4j.xdr.XdrAble;
import org.dcache.oncrpc4j.xdr.XdrDecodingStream;
import org.dcache.oncrpc4j.xdr.XdrEncodingStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcAuthTypeUnix
implements RpcAuth,
XdrAble {
    private final int _type = 1;
    private RpcAuthVerifier _verifier = new RpcAuthVerifier(0, new byte[0]);
    private int _len;
    private int _uid;
    private int _gid;
    private int[] _gids;
    private int _stamp;
    private String _machine;
    private Subject _subject;
    private static final Logger _log = LoggerFactory.getLogger(RpcAuthTypeUnix.class);

    public RpcAuthTypeUnix() {
    }

    public RpcAuthTypeUnix(int uid, int gid, int[] gids, int stamp, String machine) {
        this._uid = uid;
        this._gid = gid;
        this._gids = gids;
        this._stamp = stamp;
        this._machine = machine;
        this._len = 12 + 4 * this._gids.length + 4 + this._machine.length() + (4 - (this._machine.length() & 3) & 3) + 4;
        this._subject = RpcAuthTypeUnix.buildUnixSubject(uid, gid, gids);
    }

    @Override
    public void xdrDecode(XdrDecodingStream xdr) throws OncRpcException, IOException {
        this._len = xdr.xdrDecodeInt();
        this._stamp = xdr.xdrDecodeInt();
        this._machine = xdr.xdrDecodeString();
        this._uid = xdr.xdrDecodeInt();
        this._gid = xdr.xdrDecodeInt();
        this._gids = xdr.xdrDecodeIntVector();
        this._verifier.xdrDecode(xdr);
        this._subject = RpcAuthTypeUnix.buildUnixSubject(this._uid, this._gid, this._gids);
    }

    private static Subject buildUnixSubject(int uid, int gid, int[] gids) {
        Subject unixSubject = new Subject();
        Set<Principal> principals = unixSubject.getPrincipals();
        principals.add(new UnixNumericUserPrincipal(uid));
        principals.add(new UnixNumericGroupPrincipal(gid, true));
        for (int gidElem : gids) {
            principals.add(new UnixNumericGroupPrincipal(gidElem, false));
        }
        return unixSubject;
    }

    @Override
    public Subject getSubject() {
        return this._subject;
    }

    @Override
    public int type() {
        return 1;
    }

    @Override
    public RpcAuthVerifier getVerifier() {
        return this._verifier;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Host: ").append(this._machine).append("\n");
        sb.append("timestamp: ").append(this._stamp).append("\n");
        sb.append("uid: ").append(this._uid).append("\n");
        sb.append("gid: ").append(this._gid).append("\n");
        sb.append("gids: ").append(Arrays.toString(this._gids)).append("\n");
        return sb.toString();
    }

    @Override
    public void xdrEncode(XdrEncodingStream xdr) throws OncRpcException, IOException {
        xdr.xdrEncodeInt(1);
        xdr.xdrEncodeInt(this._len);
        xdr.xdrEncodeInt(this._stamp);
        xdr.xdrEncodeString(this._machine);
        xdr.xdrEncodeInt(this._uid);
        xdr.xdrEncodeInt(this._gid);
        xdr.xdrEncodeIntVector(this._gids);
        this._verifier.xdrEncode(xdr);
    }

    public int uid() {
        return this._uid;
    }

    public int gid() {
        return this._gid;
    }

    public int[] gids() {
        return this._gids;
    }

    public static RpcAuthTypeUnix ofCurrentUnixUser() throws IllegalStateException, IOException {
        String os = System.getProperty("os.name");
        Preconditions.checkState((!os.toLowerCase().startsWith("windows") ? 1 : 0) != 0, (String)"%s platform not supported", (Object)os);
        UnixSystem user = new UnixSystem();
        long uid = user.getUid();
        long gid = user.getGid();
        long[] gids = user.getGroups();
        return new RpcAuthTypeUnix((int)uid, (int)gid, Arrays.stream(gids).mapToInt(l -> (int)l).toArray(), (int)Instant.now().getEpochSecond(), InetAddress.getLocalHost().getHostName());
    }
}

