/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.rpc;

import java.io.EOFException;
import java.net.SocketAddress;
import java.nio.channels.CompletionHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcache.oncrpc4j.rpc.RpcReply;
import org.dcache.oncrpc4j.rpc.RpcTransport;

public class ReplyQueue {
    private final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){
        private final AtomicInteger counter = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "timeout thread #" + this.counter.incrementAndGet() + " for ReplyQueue " + ReplyQueue.this);
            t.setDaemon(true);
            return t;
        }
    });
    private final ConcurrentMap<Integer, PendingRequest> _queue = new ConcurrentHashMap<Integer, PendingRequest>();

    public void registerKey(int xid, SocketAddress addr, CompletionHandler<RpcReply, RpcTransport> callback) throws EOFException {
        this.registerKey(xid, addr, callback, 0L, null);
    }

    public void registerKey(int xid, SocketAddress addr, CompletionHandler<RpcReply, RpcTransport> callback, long timeout, TimeUnit timeoutUnits) throws EOFException {
        ScheduledFuture<?> scheduledTimeout = null;
        if (timeout > 0L && timeoutUnits != null) {
            scheduledTimeout = this.executorService.schedule(() -> {
                CompletionHandler<RpcReply, RpcTransport> handler = this.get(xid);
                if (handler != null) {
                    handler.failed(new TimeoutException("did not get a response within " + timeout + " " + (Object)((Object)timeoutUnits)), null);
                }
            }, timeout, timeoutUnits);
        }
        this._queue.put(xid, new PendingRequest(addr, callback, scheduledTimeout));
    }

    public void handleDisconnect(SocketAddress addr) {
        EOFException eofException = new EOFException("Disconnected");
        this._queue.entrySet().stream().filter(e -> ((PendingRequest)e.getValue()).addr.equals(addr)).forEach(e -> {
            ((PendingRequest)e.getValue()).failed(eofException);
            this._queue.remove(e.getKey());
        });
    }

    public CompletionHandler<RpcReply, RpcTransport> get(int xid) {
        PendingRequest request = (PendingRequest)this._queue.remove(xid);
        if (request != null) {
            request.cancelTimeout();
            return request.handler;
        }
        return null;
    }

    public Collection<PendingRequest> getPendingRequests() {
        return Collections.unmodifiableCollection(this._queue.values());
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    public static class PendingRequest {
        private final CompletionHandler<RpcReply, RpcTransport> handler;
        private final ScheduledFuture<?> scheduledTimeout;
        private final SocketAddress addr;

        public PendingRequest(SocketAddress addr, CompletionHandler<RpcReply, RpcTransport> handler, ScheduledFuture<?> scheduledTimeout) {
            this.handler = handler;
            this.scheduledTimeout = scheduledTimeout;
            this.addr = addr;
        }

        void cancelTimeout() {
            if (this.scheduledTimeout != null) {
                this.scheduledTimeout.cancel(false);
            }
        }

        void failed(Throwable t) {
            this.cancelTimeout();
            this.handler.failed(t, null);
        }
    }
}

