/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.grizzly;

import com.google.common.annotations.Beta;
import java.io.IOException;
import java.util.List;
import org.dcache.oncrpc4j.rpc.RpcAuthError;
import org.dcache.oncrpc4j.rpc.RpcAuthException;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class StartTlsFilter
extends BaseFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartTlsFilter.class);
    private final SSLFilter sslFilter;
    private final boolean isClient;
    private volatile boolean start;

    public StartTlsFilter(SSLFilter sslFilter, boolean isClient) {
        this.sslFilter = sslFilter;
        this.isClient = isClient;
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        NextAction nextAction = super.handleWrite(ctx);
        if (this.start) {
            this.enableSSLFilter(ctx.getConnection());
        }
        return nextAction;
    }

    public void startTLS(Connection connection) throws RpcAuthException {
        this.start = true;
        if (this.isClient) {
            this.enableSSLFilter(connection);
            try {
                this.sslFilter.handshake(connection, (CompletionHandler)new EmptyCompletionHandler());
            }
            catch (IOException e) {
                LOGGER.error("Failed to perform TLS handshake: {}", (Object)e.getMessage());
                throw new RpcAuthException("Failed to perform TLS handshake", new RpcAuthError(7));
            }
        }
    }

    private void enableSSLFilter(Connection connection) {
        FilterChain currentChain = (FilterChain)connection.getProcessor();
        FilterChainBuilder chainBuilder = FilterChainBuilder.stateless().addAll((List)currentChain).remove((Filter)this).add(1, (Filter)this.sslFilter);
        connection.setProcessor((Processor)chainBuilder.build());
    }
}

