/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DirectoryDelimiterPathContainerService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.azure.AzureAttributesFinderFeature;
import ch.cyberduck.core.azure.AzureExceptionMappingService;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.io.VoidStatusOutputStream;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.shared.AppendWriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobOutputStream;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.BlobType;
import com.microsoft.azure.storage.blob.CloudAppendBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;

public class AzureWriteFeature
extends AppendWriteFeature<Void>
implements Write<Void> {
    private static final Logger log = LogManager.getLogger(AzureWriteFeature.class);
    private final AzureSession session;
    private final OperationContext context;
    private final PathContainerService containerService = new DirectoryDelimiterPathContainerService();
    private final BlobType blobType;

    public AzureWriteFeature(AzureSession session, OperationContext context) {
        this(session, BlobType.valueOf((String)new HostPreferences(session.getHost()).getProperty("azure.upload.blobtype")), context);
    }

    public AzureWriteFeature(AzureSession session, BlobType blobType, OperationContext context) {
        this.session = session;
        this.blobType = blobType;
        this.context = context;
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        return ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.md5);
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        PathAttributes attr;
        Write.Append append = super.append(file, status);
        if (append.append && BlobType.APPEND_BLOB == BlobType.valueOf((String)((String)(attr = new AzureAttributesFinderFeature(this.session, this.context).find(file)).getCustom().get("blob_type")))) {
            return append;
        }
        return Write.override;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StatusOutputStream<Void> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            BlobOutputStream out;
            Checksum checksum;
            void var4_10;
            if (status.isExists()) {
                if (new HostPreferences(this.session.getHost()).getBoolean("azure.upload.snapshot")) {
                    ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName()).getBlobReferenceFromServer(this.containerService.getKey(file)).createSnapshot();
                }
                if (status.isAppend()) {
                    CloudAppendBlob cloudAppendBlob = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName()).getAppendBlobReference(this.containerService.getKey(file));
                } else {
                    PathAttributes attr = new AzureAttributesFinderFeature(this.session, this.context).find(file);
                    if (BlobType.APPEND_BLOB == BlobType.valueOf((String)((String)attr.getCustom().get("blob_type")))) {
                        CloudAppendBlob cloudAppendBlob = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName()).getAppendBlobReference(this.containerService.getKey(file));
                    } else {
                        CloudBlockBlob cloudBlockBlob = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName()).getBlockBlobReference(this.containerService.getKey(file));
                    }
                }
            } else {
                switch (this.blobType) {
                    case APPEND_BLOB: {
                        CloudAppendBlob cloudAppendBlob = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName()).getAppendBlobReference(this.containerService.getKey(file));
                        break;
                    }
                    default: {
                        CloudBlockBlob cloudBlockBlob = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName()).getBlockBlobReference(this.containerService.getKey(file));
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)status.getMime())) {
                var4_10.getProperties().setContentType(status.getMime());
            }
            HashMap headers = new HashMap(status.getMetadata());
            var4_10.setMetadata(headers);
            if (headers.containsKey("Cache-Control")) {
                var4_10.getProperties().setCacheControl((String)headers.get("Cache-Control"));
                headers.remove("Cache-Control");
            }
            if (headers.containsKey("Content-Type")) {
                var4_10.getProperties().setContentType((String)headers.get("Content-Type"));
                headers.remove("Content-Type");
            }
            if (Checksum.NONE != (checksum = status.getChecksum())) {
                switch (checksum.algorithm) {
                    case md5: {
                        try {
                            var4_10.getProperties().setContentMD5(Base64.toBase64String((byte[])Hex.decodeHex((char[])status.getChecksum().hash.toCharArray())));
                            headers.remove("Content-MD5");
                            break;
                        }
                        catch (DecoderException decoderException) {
                            // empty catch block
                        }
                    }
                }
            }
            BlobRequestOptions options = new BlobRequestOptions();
            options.setConcurrentRequestCount(Integer.valueOf(1));
            options.setStoreBlobContentMD5(Boolean.valueOf(new HostPreferences(this.session.getHost()).getBoolean("azure.upload.md5")));
            if (status.isAppend()) {
                options.setStoreBlobContentMD5(Boolean.valueOf(false));
                if (!(var4_10 instanceof CloudAppendBlob)) throw new NotfoundException(String.format("Unexpected blob type for %s", var4_10.getName()));
                out = ((CloudAppendBlob)var4_10).openWriteExisting(AccessCondition.generateEmptyCondition(), options, this.context);
                return new VoidStatusOutputStream((OutputStream)out){

                    protected void handleIOException(IOException e) throws IOException {
                        if (StringUtils.equals((CharSequence)"Stream is already closed.", (CharSequence)e.getMessage())) {
                            log.warn(String.format("Ignore failure %s", e));
                            return;
                        }
                        Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
                        if (cause instanceof StorageException) {
                            throw new IOException(e.getMessage(), (Throwable)new AzureExceptionMappingService().map((StorageException)cause));
                        }
                        throw e;
                    }
                };
            } else {
                out = var4_10 instanceof CloudAppendBlob ? ((CloudAppendBlob)var4_10).openWriteNew(AccessCondition.generateEmptyCondition(), options, this.context) : ((CloudBlockBlob)var4_10).openOutputStream(AccessCondition.generateEmptyCondition(), options, this.context);
            }
            return new /* invalid duplicate definition of identical inner class */;
        }
        catch (StorageException storageException) {
            throw new AzureExceptionMappingService().map("Upload {0} failed", storageException, file);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new NotfoundException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
        }
    }
}

