/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.azure.AzureAttributesFinderFeature;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.azure.AzureWriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.shared.DefaultTouchFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import com.microsoft.azure.storage.OperationContext;
import java.io.InputStream;
import org.apache.commons.io.input.NullInputStream;

public class AzureTouchFeature
extends DefaultTouchFeature<Void> {
    private final AzureSession session;
    private final OperationContext context;

    public AzureTouchFeature(AzureSession session, OperationContext context) {
        super((Write)new AzureWriteFeature(session, context));
        this.session = session;
        this.context = context;
    }

    public boolean isSupported(Path workdir, String filename) {
        return !workdir.isRoot();
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        status.setChecksum(this.write.checksum(file, status).compute((InputStream)new NullInputStream(0L), status));
        return super.touch(file, status).withAttributes(new AzureAttributesFinderFeature(this.session, this.context).find(file));
    }
}

