/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DirectoryDelimiterPathContainerService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.azure.AzureExceptionMappingService;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.io.StreamCopier;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobInputStream;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AzureReadFeature
implements Read {
    private static final Logger log = LogManager.getLogger(AzureReadFeature.class);
    private final AzureSession session;
    private final OperationContext context;
    private final PathContainerService containerService = new DirectoryDelimiterPathContainerService();

    public AzureReadFeature(AzureSession session, OperationContext context) {
        this.session = session;
        this.context = context;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            CloudBlob blob = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName()).getBlobReferenceFromServer(this.containerService.getKey(file));
            if (0L == blob.getProperties().getLength()) {
                return new NullInputStream(0L);
            }
            BlobRequestOptions options = new BlobRequestOptions();
            options.setConcurrentRequestCount(Integer.valueOf(1));
            BlobInputStream in = blob.openInputStream(AccessCondition.generateEmptyCondition(), options, this.context);
            if (status.isAppend()) {
                try {
                    return StreamCopier.skip((InputStream)in, (long)status.getOffset());
                }
                catch (IndexOutOfBoundsException e) {
                    throw new DefaultExceptionMappingService().map((Throwable)e);
                }
            }
            return new ProxyInputStream((InputStream)in){

                protected void handleIOException(IOException e) throws IOException {
                    if (StringUtils.equals((CharSequence)"Stream is already closed.", (CharSequence)e.getMessage())) {
                        log.warn(String.format("Ignore failure %s", e));
                        return;
                    }
                    Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
                    if (cause instanceof StorageException) {
                        throw new IOException(e.getMessage(), (Throwable)new AzureExceptionMappingService().map((StorageException)cause));
                    }
                    throw e;
                }
            };
        }
        catch (StorageException e) {
            throw new AzureExceptionMappingService().map("Download {0} failed", e, file);
        }
        catch (URISyntaxException e) {
            throw new NotfoundException(e.getMessage(), (Throwable)e);
        }
    }
}

