/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.RootListService;
import ch.cyberduck.core.azure.AzureExceptionMappingService;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.HostPreferences;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.ResultContinuation;
import com.microsoft.azure.storage.ResultSegment;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.ContainerListingDetails;
import java.util.EnumSet;

public class AzureContainerListService
implements RootListService {
    private final AzureSession session;
    private final OperationContext context;

    public AzureContainerListService(AzureSession session, OperationContext context) {
        this.session = session;
        this.context = context;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        ResultContinuation token = null;
        try {
            ResultSegment result;
            AttributedList containers = new AttributedList();
            do {
                BlobRequestOptions options = new BlobRequestOptions();
                result = ((CloudBlobClient)this.session.getClient()).listContainersSegmented(null, ContainerListingDetails.NONE, Integer.valueOf(new HostPreferences(this.session.getHost()).getInteger("azure.listing.chunksize")), token, options, this.context);
                for (CloudBlobContainer container : result.getResults()) {
                    PathAttributes attributes = new PathAttributes();
                    attributes.setETag(container.getProperties().getEtag());
                    attributes.setModificationDate(container.getProperties().getLastModified().getTime());
                    containers.add((Referenceable)new Path(PathNormalizer.normalize((String)container.getName()), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory), attributes));
                }
                listener.chunk(directory, containers);
                token = result.getContinuationToken();
            } while (result.getHasMoreResults());
            return containers;
        }
        catch (StorageException e) {
            throw new AzureExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }
}

