/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.eue.ChunkListSHA256ChecksumCompute;
import ch.cyberduck.core.eue.EueAttributesAdapter;
import ch.cyberduck.core.eue.EueExceptionMappingService;
import ch.cyberduck.core.eue.EueResourceIdProvider;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.EueUploadHelper;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceCreationResponseEntry;
import ch.cyberduck.core.eue.io.swagger.client.model.UploadType;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.SHA256ChecksumCompute;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EueWriteFeature
extends AbstractHttpWriteFeature<Chunk> {
    private static final Logger log = LogManager.getLogger(EueWriteFeature.class);
    public static final String RESOURCE_ID = "resourceId";
    private final EueSession session;
    private final EueResourceIdProvider fileid;

    public EueWriteFeature(EueSession session, EueResourceIdProvider fileid) {
        super((AttributesAdapter)new EueAttributesAdapter());
        this.session = session;
        this.fileid = fileid;
    }

    public HttpResponseOutputStream<Chunk> write(Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        String uploadUri;
        String resourceId;
        if (null == status.getUrl()) {
            if (status.isExists()) {
                resourceId = this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener());
                uploadUri = EueUploadHelper.updateResource(this.session, resourceId, status, UploadType.SIMPLE).getUploadURI();
            } else {
                ResourceCreationResponseEntry uploadResourceCreationResponseEntry = EueUploadHelper.createResource(this.session, this.fileid.getFileId(file.getParent(), (ListProgressListener)new DisabledListProgressListener()), file.getName(), status, UploadType.SIMPLE);
                resourceId = EueResourceIdProvider.getResourceIdFromResourceUri(uploadResourceCreationResponseEntry.getHeaders().getLocation());
                uploadUri = uploadResourceCreationResponseEntry.getEntity().getUploadURI();
            }
        } else {
            uploadUri = status.getUrl();
            resourceId = (String)status.getParameters().get(RESOURCE_ID);
        }
        HttpResponseOutputStream stream = this.write(file, status, (DelayedHttpEntityCallable)new DelayedHttpEntityCallable<Chunk>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Chunk call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    CloseableHttpResponse response;
                    HttpPost request;
                    StringBuilder uploadUriWithParameters = new StringBuilder(uploadUri);
                    if (!Checksum.NONE.equals((Object)status.getChecksum())) {
                        uploadUriWithParameters.append(String.format("&x_cdash64=%s", new ChunkListSHA256ChecksumCompute().compute(status.getLength(), Hex.decodeHex((String)status.getChecksum().hash))));
                    }
                    if (status.getLength() != -1L) {
                        uploadUriWithParameters.append(String.format("&x_size=%d", status.getLength()));
                    }
                    if (status.isSegment()) {
                        uploadUriWithParameters.append(String.format("&x_offset=%d", new HostPreferences(EueWriteFeature.this.session.getHost()).getLong("eue.upload.multipart.size") * (long)(status.getPart() - 1)));
                        request = new HttpPut(uploadUriWithParameters.toString());
                        request.setEntity((HttpEntity)entity);
                        response = ((CloseableHttpClient)EueWriteFeature.this.session.getClient()).execute((HttpUriRequest)request);
                    } else {
                        request = new HttpPost(uploadUriWithParameters.toString());
                        request.setEntity((HttpEntity)entity);
                        request.setHeader("Content-Type", "application/octet-stream");
                        response = ((CloseableHttpClient)EueWriteFeature.this.session.getClient()).execute((HttpUriRequest)request);
                    }
                    try {
                        if (response.getStatusLine().getStatusCode() == 200) {
                            Chunk chunk = new Chunk(resourceId, status.getPart(), status.getLength(), status.getChecksum());
                            return chunk;
                        }
                        EntityUtils.updateEntity((HttpResponse)response, (HttpEntity)new BufferedHttpEntity(response.getEntity()));
                        throw new EueExceptionMappingService().map((HttpResponse)response);
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                }
                catch (HttpResponseException e) {
                    throw new DefaultHttpResponseExceptionMappingService().map(e);
                }
                catch (IOException e) {
                    throw new DefaultIOExceptionMappingService().map(e);
                }
                catch (DecoderException e) {
                    throw new ChecksumException(LocaleFactory.localizedString((String)"Checksum failure", (String)"Error"), (Throwable)e);
                }
            }

            public long getContentLength() {
                return status.getLength();
            }
        });
        this.fileid.cache(file, resourceId);
        return stream;
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        return new SHA256ChecksumCompute();
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }

    public boolean timestamp() {
        return true;
    }

    public void cancel(String uploadUri) throws BackgroundException {
        HttpDelete request = new HttpDelete(uploadUri);
        try {
            ((CloseableHttpClient)this.session.getClient()).execute((HttpUriRequest)request);
        }
        catch (HttpResponseException e) {
            throw new DefaultHttpResponseExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public static final class Chunk {
        private final String resourceId;
        private final Integer partnumber;
        private final Long length;
        private final String cdash64;
        private final Checksum checksum;

        public Chunk(String resourceId, Long length, String cdash64) {
            this.resourceId = resourceId;
            this.partnumber = -1;
            this.length = length;
            this.cdash64 = cdash64;
            this.checksum = Checksum.NONE;
        }

        public Chunk(String resourceId, Integer partnumber, Long length, Checksum checksum) {
            this.resourceId = resourceId;
            this.partnumber = partnumber;
            this.length = length;
            this.cdash64 = "";
            this.checksum = checksum;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public Integer getPartnumber() {
            return this.partnumber;
        }

        public Long getLength() {
            return this.length;
        }

        public String getCdash64() {
            return this.cdash64;
        }

        public Checksum getChecksum() {
            return this.checksum;
        }
    }
}

