/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.eue.EueApiClient;
import ch.cyberduck.core.eue.EueExceptionMappingService;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.io.swagger.client.ApiException;
import ch.cyberduck.core.eue.io.swagger.client.JSON;
import ch.cyberduck.core.eue.io.swagger.client.api.PostChildrenApi;
import ch.cyberduck.core.eue.io.swagger.client.api.PostChildrenForAliasApi;
import ch.cyberduck.core.eue.io.swagger.client.api.PostResourceApi;
import ch.cyberduck.core.eue.io.swagger.client.model.FileUpdateResponseRepresentation;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceCreationPropertiesModel;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceCreationRepresentationArrayInner;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceCreationResponseEntries;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceCreationResponseEntry;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceResourceIdBody;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceUpdateModel;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceUpdateModelUpdate;
import ch.cyberduck.core.eue.io.swagger.client.model.UiFsModel;
import ch.cyberduck.core.eue.io.swagger.client.model.UiWin32;
import ch.cyberduck.core.eue.io.swagger.client.model.Uifs;
import ch.cyberduck.core.eue.io.swagger.client.model.UploadType;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.transfer.TransferStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.http.HttpResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

public final class EueUploadHelper {
    private static final Logger log = LogManager.getLogger(EueUploadHelper.class);
    private static final String CDOS_REF_ID = "X-UI-CDOS-RefId";
    private static final String CDOS_STORE_ID = "X-UI-CDOS-StoreId";

    public static UploadResponse parseUploadResponse(HttpResponse response) throws IOException {
        UploadResponse uploadResponse = new UploadResponse();
        if (response.containsHeader(CDOS_STORE_ID)) {
            uploadResponse.setStoreId(response.getFirstHeader(CDOS_STORE_ID).getValue());
        }
        if (!response.containsHeader(CDOS_REF_ID)) {
            return EueUploadHelper.parseUploadCompletedResponse(response);
        }
        uploadResponse.setReferenceId(response.getFirstHeader(CDOS_REF_ID).getValue());
        return uploadResponse;
    }

    public static UploadResponse parseUploadCompletedResponse(HttpResponse response) throws IOException {
        UploadResponse uploadResponse = new UploadResponse();
        UiFsModel uiFsModel = (UiFsModel)new JSON().getContext(UiFsModel.class).readValue((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8), UiFsModel.class);
        Uifs uifs = uiFsModel.getUifs();
        uploadResponse.setTotalSze(uifs.getSize());
        uploadResponse.setCdash64(uifs.getCdash64());
        uploadResponse.setReferenceId(uifs.getReferenceId());
        uploadResponse.setStoreId(uifs.getStoreId());
        return uploadResponse;
    }

    public static FileUpdateResponseRepresentation updateResource(EueSession session, String resourceId, TransferStatus status, UploadType uploadType) throws BackgroundException {
        try {
            ResourceResourceIdBody body = new ResourceResourceIdBody().uploadType(uploadType);
            if (status.getTimestamp() != null) {
                ResourceUpdateModelUpdate update = new ResourceUpdateModelUpdate();
                update.setUiwin32(new UiWin32().lastModificationMillis(new DateTime((Object)status.getTimestamp()).getMillis()));
                body.setPatch(new ResourceUpdateModel().update(update));
            }
            return new PostResourceApi(new EueApiClient(session)).resourceResourceIdPost(resourceId, body, null, null, null, null);
        }
        catch (ApiException e) {
            throw new EueExceptionMappingService().map(e);
        }
    }

    public static ResourceCreationResponseEntry createResource(EueSession session, String resourceId, String filename, TransferStatus status, UploadType uploadType) throws BackgroundException {
        ResourceCreationRepresentationArrayInner resourceCreationRepresentation = new ResourceCreationRepresentationArrayInner();
        resourceCreationRepresentation.setForceOverwrite(true);
        resourceCreationRepresentation.setPath(filename);
        if (-1L != status.getLength()) {
            resourceCreationRepresentation.setSize(status.getLength());
        }
        resourceCreationRepresentation.setUploadType(uploadType);
        resourceCreationRepresentation.setResourceType(ResourceCreationRepresentationArrayInner.ResourceTypeEnum.FILE);
        if (status.getTimestamp() != null) {
            ResourceCreationPropertiesModel property = new ResourceCreationPropertiesModel();
            property.setUiwin32(new UiWin32().lastModificationMillis(new DateTime((Object)status.getTimestamp()).getMillis()));
            resourceCreationRepresentation.setProperties(property);
        }
        try {
            ResourceCreationResponseEntries resourceCreationResponseEntries;
            EueApiClient client = new EueApiClient(session);
            switch (resourceId) {
                case "ROOT": {
                    resourceCreationResponseEntries = new PostChildrenForAliasApi(client).resourceAliasAliasChildrenPost(resourceId, Collections.singletonList(resourceCreationRepresentation), null, null, null, null, null);
                    break;
                }
                default: {
                    resourceCreationResponseEntries = new PostChildrenApi(client).resourceResourceIdChildrenPost(resourceId, Collections.singletonList(resourceCreationRepresentation), null, null, null, null, null);
                }
            }
            if (!resourceCreationResponseEntries.containsKey(filename)) {
                throw new NotfoundException(filename);
            }
            ResourceCreationResponseEntry resourceCreationResponseEntry = (ResourceCreationResponseEntry)resourceCreationResponseEntries.get(filename);
            switch (resourceCreationResponseEntry.getStatusCode()) {
                case 201: {
                    break;
                }
                default: {
                    log.warn(String.format("Failure %s creating file %s", resourceCreationResponseEntry, filename));
                    if (null == resourceCreationResponseEntry.getEntity()) {
                        throw new EueExceptionMappingService().map(new ApiException(resourceCreationResponseEntry.getReason(), null, resourceCreationResponseEntry.getStatusCode(), client.getResponseHeaders()));
                    }
                    throw new EueExceptionMappingService().map(new ApiException(resourceCreationResponseEntry.getEntity().getError(), null, resourceCreationResponseEntry.getStatusCode(), client.getResponseHeaders()));
                }
            }
            return resourceCreationResponseEntry;
        }
        catch (ApiException e) {
            throw new EueExceptionMappingService().map(e);
        }
    }

    public static class UploadResponse {
        @JsonProperty(value="cdash64")
        private String cdash64 = null;
        @JsonProperty(value="referenceId")
        private String referenceId = null;
        @JsonProperty(value="storeId")
        private String storeId = null;
        @JsonProperty(value="totalSize")
        private Long totalSze = null;

        public String getCdash64() {
            return this.cdash64;
        }

        public void setCdash64(String cdash64) {
            this.cdash64 = cdash64;
        }

        public String getReferenceId() {
            return this.referenceId;
        }

        public void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        public String getStoreId() {
            return this.storeId;
        }

        public void setStoreId(String storeId) {
            this.storeId = storeId;
        }

        public Long getTotalSze() {
            return this.totalSze;
        }

        public void setTotalSze(Long totalSze) {
            this.totalSze = totalSze;
        }
    }
}

