/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.collections.Partition;
import ch.cyberduck.core.eue.EueApiClient;
import ch.cyberduck.core.eue.EueDeleteFeature;
import ch.cyberduck.core.eue.EueExceptionMappingService;
import ch.cyberduck.core.eue.EueResourceIdProvider;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.io.swagger.client.ApiException;
import ch.cyberduck.core.eue.io.swagger.client.api.MoveChildrenForAliasApiApi;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceCreationResponseEntryEntity;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceMoveResponseEntries;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceMoveResponseEntry;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Trash;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EueTrashFeature
implements Trash {
    private static final Logger log = LogManager.getLogger(EueTrashFeature.class);
    private final EueSession session;
    private final EueResourceIdProvider fileid;

    public EueTrashFeature(EueSession session, EueResourceIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        this.trash(files, prompt, callback);
        for (Path f : files.keySet()) {
            this.fileid.cache(f, null);
        }
    }

    protected List<String> trash(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        ArrayList<String> resources;
        block16: {
            resources = new ArrayList<String>();
            try {
                block11: for (Path f : files.keySet()) {
                    switch (this.fileid.getFileId(f.getParent(), (ListProgressListener)new DisabledListProgressListener())) {
                        case "TRASH": {
                            log.warn(String.format("Delete file %s already in trash", f));
                            new EueDeleteFeature(this.session, this.fileid).delete(Collections.singletonList(this.fileid.getFileId(f, (ListProgressListener)new DisabledListProgressListener())));
                            continue block11;
                        }
                    }
                    resources.add(this.fileid.getFileId(f, (ListProgressListener)new DisabledListProgressListener()));
                    callback.delete(f);
                }
                if (!resources.isEmpty()) {
                    EueApiClient client = new EueApiClient(this.session);
                    for (List partition : new Partition(resources.stream().map(resourceId -> String.format("%s/resource/%s", this.session.getBasePath(), resourceId)).collect(Collectors.toList()), new HostPreferences(this.session.getHost()).getInteger("eue.delete.multiple.partition"))) {
                        ResourceMoveResponseEntries resourceMoveResponseEntries = new MoveChildrenForAliasApiApi(client).resourceAliasAliasChildrenMovePost("TRASH", partition, null, null, null, "rename", null);
                        if (null == resourceMoveResponseEntries) continue;
                        block13: for (ResourceMoveResponseEntry resourceMoveResponseEntry : resourceMoveResponseEntries.values()) {
                            switch (resourceMoveResponseEntry.getStatusCode()) {
                                case 200: {
                                    continue block13;
                                }
                            }
                            log.warn(String.format("Failure %s trashing resource %s", resourceMoveResponseEntries, resourceMoveResponseEntry));
                            ResourceCreationResponseEntryEntity entity = resourceMoveResponseEntry.getEntity();
                            if (null == entity) {
                                throw new EueExceptionMappingService().map(new ApiException(resourceMoveResponseEntry.getReason(), null, resourceMoveResponseEntry.getStatusCode(), client.getResponseHeaders()));
                            }
                            throw new EueExceptionMappingService().map(new ApiException(resourceMoveResponseEntry.getEntity().getError(), null, resourceMoveResponseEntry.getStatusCode(), client.getResponseHeaders()));
                        }
                    }
                }
            }
            catch (ApiException e) {
                Iterator<Path> iterator = files.keySet().iterator();
                if (!iterator.hasNext()) break block16;
                Path f = iterator.next();
                throw new EueExceptionMappingService().map("Cannot delete {0}", e, f);
            }
        }
        return resources;
    }

    public boolean isSupported(Path file) {
        return !StringUtils.equals((CharSequence)"TRASH", (CharSequence)file.attributes().getFileId()) && !StringUtils.equals((CharSequence)this.session.getHost().getProperty("cryptomator.vault.name.default"), (CharSequence)file.getName());
    }

    public boolean isRecursive() {
        return true;
    }
}

