/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.eue.EueApiClient;
import ch.cyberduck.core.eue.EueExceptionMappingService;
import ch.cyberduck.core.eue.EueResourceIdProvider;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.io.swagger.client.ApiException;
import ch.cyberduck.core.eue.io.swagger.client.api.UpdateResourceApi;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceUpdateModel;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceUpdateModelUpdate;
import ch.cyberduck.core.eue.io.swagger.client.model.UiWin32;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.shared.DefaultTimestampFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import org.joda.time.DateTime;

public class EueTimestampFeature
extends DefaultTimestampFeature {
    private final EueSession session;
    private final EueResourceIdProvider fileid;

    public EueTimestampFeature(EueSession session, EueResourceIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void setTimestamp(Path file, TransferStatus status) throws BackgroundException {
        try {
            String resourceId = this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener());
            ResourceUpdateModel resourceUpdateModel = new ResourceUpdateModel();
            ResourceUpdateModelUpdate resourceUpdateModelUpdate = new ResourceUpdateModelUpdate();
            UiWin32 uiWin32 = new UiWin32();
            uiWin32.setLastModificationMillis(new DateTime((Object)status.getTimestamp()).getMillis());
            resourceUpdateModelUpdate.setUiwin32(uiWin32);
            resourceUpdateModel.setUpdate(resourceUpdateModelUpdate);
            new UpdateResourceApi(new EueApiClient(this.session)).resourceResourceIdPatch(resourceId, resourceUpdateModel, null, null, null);
        }
        catch (ApiException e) {
            throw new EueExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }
}

