/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.eue.EueMultipartWriteFeature;
import ch.cyberduck.core.eue.EueResourceIdProvider;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.EueWriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.SHA256ChecksumCompute;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;

public class EueThresholdWriteFeature
implements Write<EueWriteFeature.Chunk> {
    private final EueSession session;
    private final EueResourceIdProvider fileid;
    private final Long threshold;

    public EueThresholdWriteFeature(EueSession session, EueResourceIdProvider fileid) {
        this(session, fileid, new HostPreferences(session.getHost()).getLong("eue.upload.multipart.threshold"));
    }

    public EueThresholdWriteFeature(EueSession session, EueResourceIdProvider fileid, Long threshold) {
        this.session = session;
        this.fileid = fileid;
        this.threshold = threshold;
    }

    public StatusOutputStream<EueWriteFeature.Chunk> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        if (status.getLength() >= this.threshold) {
            return new EueMultipartWriteFeature(this.session, this.fileid).write(file, status, callback);
        }
        return new EueWriteFeature(this.session, this.fileid).write(file, status, callback);
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        return new SHA256ChecksumCompute();
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }
}

