/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.eue.EueLargeUploadService;
import ch.cyberduck.core.eue.EueResourceIdProvider;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.EueSingleUploadService;
import ch.cyberduck.core.eue.EueUploadService;
import ch.cyberduck.core.eue.EueWriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.VaultRegistry;

public class EueThresholdUploadService
implements Upload<EueWriteFeature.Chunk> {
    private final EueSession session;
    private final VaultRegistry registry;
    private final Long threshold;
    private final EueResourceIdProvider fileid;
    private Write<EueWriteFeature.Chunk> writer;

    public EueThresholdUploadService(EueSession session, EueResourceIdProvider fileid, VaultRegistry registry) {
        this(session, fileid, registry, new HostPreferences(session.getHost()).getLong("eue.upload.multipart.threshold"));
    }

    public EueThresholdUploadService(EueSession session, EueResourceIdProvider fileid, VaultRegistry registry, Long threshold) {
        this.session = session;
        this.registry = registry;
        this.threshold = threshold;
        this.fileid = fileid;
        this.writer = new EueWriteFeature(session, fileid);
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return this.writer.append(file, status);
    }

    public EueWriteFeature.Chunk upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback prompt) throws BackgroundException {
        if (status.getLength() >= this.threshold) {
            if (Vault.DISABLED == this.registry.find((Session)this.session, file)) {
                return new EueLargeUploadService(this.session, this.fileid, this.writer).upload(file, local, throttle, listener, status, prompt);
            }
            return (EueWriteFeature.Chunk)new EueUploadService(this.session, this.fileid, this.writer).upload(file, local, throttle, listener, status, prompt);
        }
        return new EueSingleUploadService(this.session, this.fileid, this.writer).upload(file, local, throttle, listener, status, prompt);
    }

    public Upload<EueWriteFeature.Chunk> withWriter(Write<EueWriteFeature.Chunk> writer) {
        this.writer = writer;
        return this;
    }
}

