/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.eue.EueResourceIdProvider;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.EueUploadHelper;
import ch.cyberduck.core.eue.EueWriteFeature;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceCreationResponseEntry;
import ch.cyberduck.core.eue.io.swagger.client.model.UploadType;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.TransferStatus;
import java.security.MessageDigest;
import java.util.Collections;

public class EueSingleUploadService
extends HttpUploadFeature<EueWriteFeature.Chunk, MessageDigest> {
    private final EueSession session;
    private final EueResourceIdProvider fileid;
    private Write<EueWriteFeature.Chunk> writer;

    public EueSingleUploadService(EueSession session, EueResourceIdProvider fileid, Write<EueWriteFeature.Chunk> writer) {
        super(writer);
        this.session = session;
        this.fileid = fileid;
        this.writer = writer;
    }

    public EueWriteFeature.Chunk upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        String uploadUri;
        String resourceId;
        if (status.isExists()) {
            resourceId = this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener());
            uploadUri = EueUploadHelper.updateResource(this.session, resourceId, status, UploadType.SIMPLE).getUploadURI();
        } else {
            ResourceCreationResponseEntry uploadResourceCreationResponseEntry = EueUploadHelper.createResource(this.session, this.fileid.getFileId(file.getParent(), (ListProgressListener)new DisabledListProgressListener()), file.getName(), status, UploadType.SIMPLE);
            resourceId = EueResourceIdProvider.getResourceIdFromResourceUri(uploadResourceCreationResponseEntry.getHeaders().getLocation());
            uploadUri = uploadResourceCreationResponseEntry.getEntity().getUploadURI();
        }
        status.setParameters(Collections.singletonMap("resourceId", resourceId));
        status.setUrl(uploadUri);
        status.setChecksum(this.writer.checksum(file, status).compute(local.getInputStream(), status));
        return (EueWriteFeature.Chunk)super.upload(file, local, throttle, listener, status, callback);
    }

    public Upload<EueWriteFeature.Chunk> withWriter(Write<EueWriteFeature.Chunk> writer) {
        this.writer = writer;
        return super.withWriter(writer);
    }
}

