/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.eue.EueShareFeature;
import ch.cyberduck.core.eue.io.swagger.client.model.ShareCreationResponseEntity;
import ch.cyberduck.core.eue.io.swagger.client.model.UserSharesModel;
import java.net.URI;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EueShareUrlProvider
implements UrlProvider {
    private static final Logger log = LogManager.getLogger(EueShareUrlProvider.class);
    private final Host host;
    private final UserSharesModel shares;

    public EueShareUrlProvider(Host host, UserSharesModel shares) {
        this.host = host;
        this.shares = shares;
    }

    public DescriptiveUrlBag toUrl(Path file) {
        if (DescriptiveUrl.EMPTY == file.attributes().getLink()) {
            if (null == file.attributes().getFileId()) {
                return DescriptiveUrlBag.empty();
            }
            DescriptiveUrl share = EueShareUrlProvider.toUrl(this.host, EueShareFeature.findShareForResource(this.shares, file.attributes().getFileId()));
            if (DescriptiveUrl.EMPTY == share) {
                return DescriptiveUrlBag.empty();
            }
            return new DescriptiveUrlBag(Collections.singleton(share));
        }
        return new DescriptiveUrlBag(Collections.singleton(file.attributes().getLink()));
    }

    protected static DescriptiveUrl toUrl(Host host, ShareCreationResponseEntity shareCreationResponse) {
        if (null == shareCreationResponse) {
            return DescriptiveUrl.EMPTY;
        }
        return new DescriptiveUrl(URI.create(EueShareFeature.toBrandedUri(shareCreationResponse.getGuestURI(), host.getProperty("share.hostname"))), DescriptiveUrl.Type.signed);
    }
}

