/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.AlphanumericRandomStringService;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.eue.EueApiClient;
import ch.cyberduck.core.eue.EueExceptionMappingService;
import ch.cyberduck.core.eue.EueResourceIdProvider;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.EueShareUrlProvider;
import ch.cyberduck.core.eue.io.swagger.client.ApiException;
import ch.cyberduck.core.eue.io.swagger.client.api.CreateShareApi;
import ch.cyberduck.core.eue.io.swagger.client.api.UserInfoApi;
import ch.cyberduck.core.eue.io.swagger.client.model.ShareCreationRequestEntry;
import ch.cyberduck.core.eue.io.swagger.client.model.ShareCreationRequestModel;
import ch.cyberduck.core.eue.io.swagger.client.model.ShareCreationResponseEntity;
import ch.cyberduck.core.eue.io.swagger.client.model.ShareCreationResponseEntry;
import ch.cyberduck.core.eue.io.swagger.client.model.ShareCreationResponseModel;
import ch.cyberduck.core.eue.io.swagger.client.model.SharePermission;
import ch.cyberduck.core.eue.io.swagger.client.model.Shares;
import ch.cyberduck.core.eue.io.swagger.client.model.UserInfoResponseModel;
import ch.cyberduck.core.eue.io.swagger.client.model.UserSharesModel;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.preferences.HostPreferences;
import java.text.MessageFormat;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EueShareFeature
implements PromptUrlProvider<ShareCreationRequestModel, ShareCreationRequestModel> {
    private static final Logger log = LogManager.getLogger(EueShareFeature.class);
    private static final String GUEST_E_MAIL = "!ano";
    private final EueSession session;
    private final EueResourceIdProvider fileid;

    public EueShareFeature(EueSession session, EueResourceIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public boolean isSupported(Path file, PromptUrlProvider.Type type) {
        if (StringUtils.equals((CharSequence)"TRASH", (CharSequence)file.attributes().getFileId())) {
            return false;
        }
        if (type == PromptUrlProvider.Type.upload) {
            return file.isDirectory();
        }
        return DescriptiveUrl.EMPTY == file.attributes().getLink();
    }

    public DescriptiveUrl toDownloadUrl(Path file, ShareCreationRequestModel options, PasswordCallback callback) throws BackgroundException {
        return this.toGuestUrl(file, options, callback);
    }

    public DescriptiveUrl toUploadUrl(Path file, ShareCreationRequestModel options, PasswordCallback callback) throws BackgroundException {
        return this.toGuestUrl(file, options, callback);
    }

    private DescriptiveUrl toGuestUrl(Path file, ShareCreationRequestModel options, PasswordCallback callback) throws BackgroundException {
        ShareCreationResponseEntity shareForResource = EueShareFeature.findShareForResource(this.session.userShares(), this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener()));
        if (null != shareForResource) {
            return EueShareUrlProvider.toUrl(this.session.getHost(), shareForResource);
        }
        return EueShareUrlProvider.toUrl(this.session.getHost(), this.createGuestUri(file, callback, options));
    }

    private ShareCreationResponseEntity createGuestUri(Path file, PasswordCallback callback, ShareCreationRequestModel shareCreationRequestModel) throws BackgroundException {
        EueApiClient client = new EueApiClient(this.session);
        CreateShareApi createShareApi = new CreateShareApi(client);
        String resourceId = this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener());
        try {
            ShareCreationRequestModel shareCreationRequestEntries = null != shareCreationRequestModel ? shareCreationRequestModel : this.createShareCreationRequestModel(file, callback);
            Iterator iterator = shareCreationRequestEntries.iterator();
            if (iterator.hasNext()) {
                ShareCreationRequestEntry shareCreationRequestEntry = (ShareCreationRequestEntry)iterator.next();
                String shareName = shareCreationRequestEntry.getName();
                ShareCreationResponseModel shareCreationResponseModel = createShareApi.resourceResourceIdSharePost(resourceId, shareCreationRequestEntries, null, null);
                if (!shareCreationResponseModel.containsKey(GUEST_E_MAIL)) {
                    throw new NotfoundException(GUEST_E_MAIL);
                }
                ShareCreationResponseEntry shareCreationResponseEntry = (ShareCreationResponseEntry)shareCreationResponseModel.get(GUEST_E_MAIL);
                switch (shareCreationResponseEntry.getStatusCode()) {
                    case 200: 
                    case 201: {
                        shareCreationResponseEntry.getEntity().setResourceURI(resourceId);
                        this.session.userShares().add(shareCreationResponseEntry.getEntity());
                        return shareCreationResponseEntry.getEntity();
                    }
                }
                log.warn(String.format("Failure %s creating share for %s", shareCreationResponseEntry, file));
                if (null == shareCreationResponseEntry.getEntity()) {
                    throw new EueExceptionMappingService().map(new ApiException(shareCreationResponseEntry.getReason(), null, shareCreationResponseEntry.getStatusCode(), client.getResponseHeaders()));
                }
                throw new EueExceptionMappingService().map(new ApiException(shareCreationResponseEntry.getEntity().getError(), null, shareCreationResponseEntry.getStatusCode(), client.getResponseHeaders()));
            }
            return null;
        }
        catch (ApiException e) {
            throw new EueExceptionMappingService().map(e);
        }
    }

    protected ShareCreationRequestModel createShareCreationRequestModel(Path file, PasswordCallback callback) throws ApiException, LoginCanceledException {
        Host bookmark = this.session.getHost();
        ShareCreationRequestEntry shareCreationRequestEntry = new ShareCreationRequestEntry().name(new AlphanumericRandomStringService().random()).hasPin(false);
        if (new HostPreferences(this.session.getHost()).getBoolean("eue.share.writable")) {
            Shares.WritableSharesMinimumProtectionEnum writableSharesMinimumProtection = this.getWritableSharesMinimumProtection();
            switch (writableSharesMinimumProtection) {
                case PIN_AND_EXPIRATION: 
                case EXPIRATION: {
                    long expirationInMillis = new HostPreferences(this.session.getHost()).getLong("eue.share.expiration.millis");
                    shareCreationRequestEntry.setExpirationMillis(expirationInMillis);
                }
                case PIN: {
                    String password = callback.prompt(bookmark, LocaleFactory.localizedString((String)"Passphrase", (String)"Cryptomator"), MessageFormat.format(LocaleFactory.localizedString((String)"Create a passphrase required to access {0}", (String)"Credentials"), file.getName()), new LoginOptions().keychain(false).icon(bookmark.getProtocol().disk())).getPassword();
                    shareCreationRequestEntry.setHasPin(true);
                    shareCreationRequestEntry.setPin(password);
                }
            }
        }
        shareCreationRequestEntry.setGuestEMail(GUEST_E_MAIL);
        SharePermission sharePermission = new SharePermission();
        sharePermission.readable(new HostPreferences(this.session.getHost()).getBoolean("eue.share.readable")).writable(new HostPreferences(this.session.getHost()).getBoolean("eue.share.writable")).deletable(new HostPreferences(this.session.getHost()).getBoolean("eue.share.deletable"));
        sharePermission.setNotificationEnabled(new HostPreferences(this.session.getHost()).getBoolean("eue.share.notification.enable"));
        shareCreationRequestEntry.setPermission(sharePermission);
        shareCreationRequestEntry.setUnmountable(false);
        ShareCreationRequestModel shareCreationRequestModel = new ShareCreationRequestModel();
        shareCreationRequestModel.add(shareCreationRequestEntry);
        return shareCreationRequestModel;
    }

    protected static ShareCreationResponseEntity findShareForResource(UserSharesModel sharesModel, String resourceId) {
        return sharesModel.stream().filter(sm -> EueResourceIdProvider.getResourceIdFromResourceUri(sm.getResourceURI()).equals(resourceId)).findFirst().orElse(null);
    }

    private Shares.WritableSharesMinimumProtectionEnum getWritableSharesMinimumProtection() throws ApiException {
        UserInfoResponseModel userInfoResponseModel = new UserInfoApi(new EueApiClient(this.session)).userinfoGet(null, null);
        return userInfoResponseModel.getSettings().getShares().getWritableSharesMinimumProtection();
    }

    protected static String toBrandedUri(String guestUri, String hostname) {
        String user = StringUtils.substringBefore((String)StringUtils.substringAfter((String)StringUtils.substringAfter((String)guestUri, (String)"guest"), (int)47), (int)47);
        String share = StringUtils.substringBefore((String)StringUtils.substringAfter((String)StringUtils.substringAfter((String)guestUri, (String)"share"), (int)47), (int)47);
        return String.format("https://%s/%s/%s", hostname, user, share);
    }
}

