/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ExpiringObjectHolder;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.OAuthTokens;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.eue.EueApiClient;
import ch.cyberduck.core.eue.EueAttributesFinderFeature;
import ch.cyberduck.core.eue.EueCopyFeature;
import ch.cyberduck.core.eue.EueDeleteFeature;
import ch.cyberduck.core.eue.EueDirectoryFeature;
import ch.cyberduck.core.eue.EueExceptionMappingService;
import ch.cyberduck.core.eue.EueFindFeature;
import ch.cyberduck.core.eue.EueListService;
import ch.cyberduck.core.eue.EueMoveFeature;
import ch.cyberduck.core.eue.EueMultipartWriteFeature;
import ch.cyberduck.core.eue.EueQuotaFeature;
import ch.cyberduck.core.eue.EueReadFeature;
import ch.cyberduck.core.eue.EueResourceIdProvider;
import ch.cyberduck.core.eue.EueShareFeature;
import ch.cyberduck.core.eue.EueShareUrlProvider;
import ch.cyberduck.core.eue.EueThresholdUploadService;
import ch.cyberduck.core.eue.EueThresholdWriteFeature;
import ch.cyberduck.core.eue.EueTimestampFeature;
import ch.cyberduck.core.eue.EueTouchFeature;
import ch.cyberduck.core.eue.EueTrashFeature;
import ch.cyberduck.core.eue.io.swagger.client.ApiException;
import ch.cyberduck.core.eue.io.swagger.client.api.GetUserSharesApi;
import ch.cyberduck.core.eue.io.swagger.client.api.UserInfoApi;
import ch.cyberduck.core.eue.io.swagger.client.model.UserSharesModel;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.FileIdProvider;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Trash;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.DefaultHttpRateLimiter;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.HttpRateLimiter;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.http.RateLimitingHttpRequestInterceptor;
import ch.cyberduck.core.oauth.OAuth2AuthorizationService;
import ch.cyberduck.core.oauth.OAuth2ErrorResponseInterceptor;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.BackgroundActionPauser;
import ch.cyberduck.core.threading.CancelCallback;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.migcomponents.migbase64.Base64;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EueSession
extends HttpSession<CloseableHttpClient> {
    private static final Logger log = LogManager.getLogger(EueSession.class);
    private OAuth2RequestInterceptor authorizationService;
    private String basePath;
    private String vaultResourceId;
    private final EueResourceIdProvider resourceid = new EueResourceIdProvider(this);
    private final ExpiringObjectHolder<UserSharesModel> userShares = new ExpiringObjectHolder(Long.valueOf(new HostPreferences(this.host).getLong("eue.shares.ttl")));

    public EueSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    protected CloseableHttpClient connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)this.builder.build(proxy, (TranscriptListener)this, prompt).addInterceptorLast(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) {
                request.addHeader("Authorization", String.format("Basic %s", Base64.encodeToString((byte[])String.format("%s:%s", EueSession.this.host.getProtocol().getOAuthClientId(), EueSession.this.host.getProtocol().getOAuthClientSecret()).getBytes(StandardCharsets.UTF_8), (boolean)false)));
            }
        }).build(), this.host).withRedirectUri(this.host.getProtocol().getOAuthRedirectUrl());
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new OAuth2ErrorResponseInterceptor(this.host, this.authorizationService, prompt));
        configuration.addInterceptorLast((HttpRequestInterceptor)this.authorizationService);
        configuration.addInterceptorLast(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) {
                String identifier = new HostPreferences(EueSession.this.host).getProperty("apikey");
                if (StringUtils.isNotBlank((CharSequence)identifier)) {
                    request.addHeader((Header)new BasicHeader("X-UI-API-KEY", identifier));
                }
            }
        });
        configuration.addInterceptorLast(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) {
                String identifier = new HostPreferences(EueSession.this.host).getProperty("app");
                if (StringUtils.isNotBlank((CharSequence)identifier)) {
                    String app = String.format("%s.%s", PreferencesFactory.get().getProperty("application.version"), PreferencesFactory.get().getProperty("application.revision"));
                    request.addHeader((Header)new BasicHeader("X-UI-APP", MessageFormat.format(identifier, app)));
                    if (StringUtils.isNotBlank((CharSequence)EueSession.this.vaultResourceId) && StringUtils.contains((CharSequence)request.getRequestLine().getUri(), (CharSequence)EueSession.this.vaultResourceId)) {
                        request.setHeader((Header)new BasicHeader("X-UI-APP", MessageFormat.format(StringUtils.replace((String)identifier, (String)"/", (String)".tresor/"), app)));
                    }
                }
            }
        });
        configuration.addInterceptorLast(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) {
                Optional<Header> hint = Arrays.asList(response.getAllHeaders()).stream().filter(header -> "X-UI-TRAFFIC-HINT".equalsIgnoreCase(header.getName())).findFirst();
                if (hint.isPresent()) {
                    log.warn(String.format("Retrieved throttle warning %s", hint.get()));
                    BackgroundActionPauser pause = new BackgroundActionPauser(new BackgroundActionPauser.Callback(){

                        public void validate() {
                        }

                        public void progress(Integer seconds) {
                            log.warn(String.format("Pause for %d seconds because of traffic hint", seconds));
                        }
                    }, Integer.valueOf(new HostPreferences(EueSession.this.host).getInteger("eue.limit.hint.second")));
                    pause.await();
                }
            }
        });
        configuration.addInterceptorLast((HttpRequestInterceptor)new RateLimitingHttpRequestInterceptor((HttpRateLimiter)new DefaultHttpRateLimiter((double)new HostPreferences(this.host).getInteger("eue.limit.requests.second"))));
        return configuration.build();
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        try {
            this.authorizationService.setTokens(this.authorizationService.refresh(this.authorizationService.authorize(this.host, prompt, cancel, OAuth2AuthorizationService.FlowType.AuthorizationCode)));
        }
        catch (InteroperabilityException e) {
            log.warn(String.format("Failure %s refreshing OAuth tokens", new Object[]{e}));
            this.host.getCredentials().setOauth(OAuthTokens.EMPTY);
            this.authorizationService.setTokens(this.authorizationService.authorize(this.host, prompt, cancel, OAuth2AuthorizationService.FlowType.AuthorizationCode));
        }
        try {
            StringBuilder url = new StringBuilder();
            url.append(this.host.getProtocol().getScheme().toString()).append("://");
            url.append(this.host.getProtocol().getDefaultHostname());
            if (this.host.getProtocol().getScheme().getPort() != this.host.getPort()) {
                url.append(":").append(this.host.getPort());
            }
            String context = PathNormalizer.normalize((String)this.host.getProtocol().getContext());
            url.append(context);
            HttpGet request = new HttpGet(url.toString());
            CloseableHttpResponse response = ((CloseableHttpClient)this.client).execute((HttpUriRequest)request);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader(response.getEntity().getContent()));
                    if (!element.isJsonObject()) break;
                    JsonObject json = element.getAsJsonObject();
                    URI uri = URI.create(json.getAsJsonObject("serviceTarget").getAsJsonPrimitive("uri").getAsString());
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Set base path to %s", url));
                    }
                    this.setBasePath(uri.toString());
                    break;
                }
                default: {
                    throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                }
            }
            Credentials credentials = this.host.getCredentials();
            credentials.setUsername(new UserInfoApi(new EueApiClient(this)).userinfoGet(null, null).getAccount().getOsServiceId());
            credentials.setSaved(true);
            if (StringUtils.isNotBlank((CharSequence)this.host.getProperty("pacs.url"))) {
                try {
                    ((CloseableHttpClient)this.client).execute((HttpUriRequest)new HttpPost(this.host.getProperty("pacs.url")));
                }
                catch (IOException e) {
                    log.warn(String.format("Ignore failure %s running Personal Agent Context Service (PACS) request", e));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)new HostPreferences(this.host).getProperty("cryptomator.vault.name.default"))) {
                Path vault = new Path(new HostPreferences(this.host).getProperty("cryptomator.vault.name.default"), EnumSet.of(AbstractPath.Type.directory));
                try {
                    this.vaultResourceId = new EueAttributesFinderFeature(this, this.resourceid).find(vault).getFileId();
                    this.host.setProperty("cryptomator.enable", String.valueOf(true));
                }
                catch (NotfoundException e) {
                    log.warn(String.format("Disable vault features with no existing vault found at %s", vault));
                    this.host.setProperty("cryptomator.enable", String.valueOf(false));
                }
            }
            this.userShares.set((Object)this.userShares());
        }
        catch (ApiException e) {
            throw new EueExceptionMappingService().map(e);
        }
        catch (HttpResponseException e) {
            throw new DefaultHttpResponseExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    protected void logout() throws BackgroundException {
        try {
            ((CloseableHttpClient)this.client).close();
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        finally {
            this.resourceid.clear();
        }
    }

    public <T> T getFeature(Class<T> type) {
        return (T)super.getFeature(type);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public UserSharesModel userShares() throws BackgroundException {
        if (this.userShares.get() == null) {
            try {
                this.userShares.set((Object)new GetUserSharesApi(new EueApiClient(this)).shareGet(null, null));
            }
            catch (ApiException e) {
                throw new EueExceptionMappingService().map(e);
            }
        }
        return (UserSharesModel)this.userShares.get();
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == FileIdProvider.class) {
            return (T)((Object)this.resourceid);
        }
        if (type == ListService.class) {
            return (T)new EueListService(this, this.resourceid);
        }
        if (type == Read.class) {
            return (T)new EueReadFeature(this, this.resourceid);
        }
        if (type == Write.class) {
            return (T)new EueThresholdWriteFeature(this, this.resourceid);
        }
        if (type == MultipartWrite.class) {
            return (T)new EueMultipartWriteFeature(this, this.resourceid);
        }
        if (type == Touch.class) {
            return (T)((Object)new EueTouchFeature(this, this.resourceid));
        }
        if (type == Move.class) {
            return (T)new EueMoveFeature(this, this.resourceid);
        }
        if (type == Copy.class) {
            return (T)new EueCopyFeature(this, this.resourceid);
        }
        if (type == Directory.class) {
            return (T)new EueDirectoryFeature(this, this.resourceid);
        }
        if (type == Delete.class) {
            return (T)new EueDeleteFeature(this, this.resourceid);
        }
        if (type == Trash.class) {
            return (T)new EueTrashFeature(this, this.resourceid);
        }
        if (type == Find.class) {
            return (T)new EueFindFeature(this, this.resourceid);
        }
        if (type == AttributesFinder.class) {
            return (T)new EueAttributesFinderFeature(this, this.resourceid);
        }
        if (type == Timestamp.class) {
            return (T)((Object)new EueTimestampFeature(this, this.resourceid));
        }
        if (type == Upload.class) {
            return (T)new EueThresholdUploadService(this, this.resourceid, this.registry);
        }
        if (type == UrlProvider.class) {
            return (T)new EueShareUrlProvider(this.host, (UserSharesModel)this.userShares.get());
        }
        if (type == PromptUrlProvider.class) {
            return (T)new EueShareFeature(this, this.resourceid);
        }
        if (type == Quota.class) {
            return (T)new EueQuotaFeature(this);
        }
        return (T)super._getFeature(type);
    }
}

