/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.CachingFileIdProvider;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.eue.EueApiClient;
import ch.cyberduck.core.eue.EueExceptionMappingService;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.io.swagger.client.ApiException;
import ch.cyberduck.core.eue.io.swagger.client.api.ListResourceAliasApi;
import ch.cyberduck.core.eue.io.swagger.client.api.ListResourceApi;
import ch.cyberduck.core.eue.io.swagger.client.model.Children;
import ch.cyberduck.core.eue.io.swagger.client.model.UiFsModel;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.FileIdProvider;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.unicode.NFCNormalizer;
import ch.cyberduck.core.unicode.UnicodeNormalizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EueResourceIdProvider
extends CachingFileIdProvider
implements FileIdProvider {
    private static final Logger log = LogManager.getLogger(EueResourceIdProvider.class);
    private static final UnicodeNormalizer normalizer = new NFCNormalizer();
    public static final String ROOT = "ROOT";
    public static final String TRASH = "TRASH";
    private final EueSession session;

    public EueResourceIdProvider(EueSession session) {
        super(session.getCaseSensitivity());
        this.session = session;
    }

    public static String getResourceIdFromResourceUri(String uri) {
        if (StringUtils.contains((CharSequence)uri, (int)47)) {
            return StringUtils.substringAfterLast((String)uri, (int)47);
        }
        return uri;
    }

    public String getFileId(Path file, ListProgressListener listener) throws BackgroundException {
        try {
            UiFsModel fsModel;
            if (StringUtils.isNotBlank((CharSequence)file.attributes().getFileId())) {
                return file.attributes().getFileId();
            }
            String cached = super.getFileId(file, listener);
            if (cached != null) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Return cached fileid %s for file %s", cached, file));
                }
                return cached;
            }
            if (file.isRoot()) {
                return ROOT;
            }
            int offset = 0;
            int chunksize = new HostPreferences(this.session.getHost()).getInteger("eue.listing.chunksize");
            do {
                String parentResourceId = this.getFileId(file.getParent(), listener);
                switch (parentResourceId) {
                    case "ROOT": 
                    case "TRASH": {
                        fsModel = new ListResourceAliasApi(new EueApiClient(this.session)).resourceAliasAliasGet(parentResourceId, null, null, null, null, chunksize, offset, null, null);
                        break;
                    }
                    default: {
                        fsModel = new ListResourceApi(new EueApiClient(this.session)).resourceResourceIdGet(parentResourceId, null, null, null, null, chunksize, offset, null, null);
                    }
                }
                for (Children child : fsModel.getUifs().getChildren()) {
                    if (!child.getUifs().getName().equalsIgnoreCase(normalizer.normalize((CharSequence)file.getName()).toString())) continue;
                    return EueResourceIdProvider.getResourceIdFromResourceUri(child.getUifs().getResourceURI());
                }
                offset += chunksize;
            } while (fsModel.getUifs().getChildren().size() == chunksize);
            throw new NotfoundException(file.getAbsolute());
        }
        catch (ApiException e) {
            throw new EueExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }
}

