/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.eue.EueApiClient;
import ch.cyberduck.core.eue.EueExceptionMappingService;
import ch.cyberduck.core.eue.EueResourceIdProvider;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.io.swagger.client.ApiException;
import ch.cyberduck.core.eue.io.swagger.client.api.ListResourceApi;
import ch.cyberduck.core.eue.io.swagger.client.model.UiFsModel;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.HttpMethodReleaseInputStream;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EueReadFeature
implements Read {
    private static final Logger log = LogManager.getLogger(EueReadFeature.class);
    private final EueSession session;
    private final EueResourceIdProvider fileid;

    public EueReadFeature(EueSession session, EueResourceIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            String resourceId = this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener());
            UiFsModel uiFsModel = new ListResourceApi(new EueApiClient(this.session)).resourceResourceIdGet(resourceId, null, null, null, null, null, null, Collections.singletonList("download"), null);
            HttpGet request = new HttpGet(uiFsModel.getUilink().getDownloadURI());
            if (status.isAppend()) {
                HttpRange range = HttpRange.withStatus((TransferStatus)status);
                String header = -1L == range.getEnd() ? String.format("bytes=%d-", range.getStart()) : String.format("bytes=%d-%d", range.getStart(), range.getEnd());
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add range header %s for file %s", header, file));
                }
                request.addHeader((Header)new BasicHeader("Range", header));
                request.addHeader((Header)new BasicHeader("Accept-Encoding", "identity"));
            }
            CloseableHttpResponse response = ((CloseableHttpClient)this.session.getClient()).execute((HttpUriRequest)request);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: 
                case 206: {
                    return new HttpMethodReleaseInputStream((HttpResponse)response);
                }
            }
            throw new DefaultHttpResponseExceptionMappingService().map("Download {0} failed", (Throwable)new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()), file);
        }
        catch (ApiException e) {
            throw new EueExceptionMappingService().map("Download {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Download {0} failed", (Throwable)e, file);
        }
    }
}

