/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.Session;
import ch.cyberduck.core.eue.EueApiClient;
import ch.cyberduck.core.eue.EueExceptionMappingService;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.io.swagger.client.ApiException;
import ch.cyberduck.core.eue.io.swagger.client.api.UserInfoApi;
import ch.cyberduck.core.eue.io.swagger.client.model.UserInfoResponseModel;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EueQuotaFeature
implements Quota {
    private static final Logger log = LogManager.getLogger(EueQuotaFeature.class);
    private final EueSession session;

    public EueQuotaFeature(EueSession session) {
        this.session = session;
    }

    public Quota.Space get() throws BackgroundException {
        try {
            EueApiClient client = new EueApiClient(this.session);
            UserInfoApi userInfoApi = new UserInfoApi(client);
            UserInfoResponseModel userInfoResponseModel = userInfoApi.userinfoGet(null, null);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Received user info %s", userInfoResponseModel));
            }
            return new Quota.Space(userInfoResponseModel.getQuotas().getContentSize().getCurrent(), Long.valueOf(userInfoResponseModel.getQuotas().getContentSize().getMax() - userInfoResponseModel.getQuotas().getContentSize().getCurrent()));
        }
        catch (ApiException e) {
            throw new EueExceptionMappingService().map("Failure to read attributes of {0}", e, new DefaultHomeFinderService((Session)this.session).find());
        }
    }
}

