/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.eue.ChunkListSHA256ChecksumCompute;
import ch.cyberduck.core.eue.EueAttributesAdapter;
import ch.cyberduck.core.eue.EueExceptionMappingService;
import ch.cyberduck.core.eue.EueMultipartUploadCompleter;
import ch.cyberduck.core.eue.EueResourceIdProvider;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.EueUploadHelper;
import ch.cyberduck.core.eue.EueWriteFeature;
import ch.cyberduck.core.eue.io.swagger.client.ApiException;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceCreationResponseEntry;
import ch.cyberduck.core.eue.io.swagger.client.model.UploadType;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.io.SHA256ChecksumCompute;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EueMultipartWriteFeature
implements MultipartWrite<EueWriteFeature.Chunk> {
    private static final Logger log = LogManager.getLogger(EueMultipartWriteFeature.class);
    private final EueSession session;
    private final EueResourceIdProvider fileid;

    public EueMultipartWriteFeature(EueSession session, EueResourceIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }

    public HttpResponseOutputStream<EueWriteFeature.Chunk> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        MultipartOutputStream proxy;
        String uploadUri;
        String resourceId;
        if (status.isExists()) {
            resourceId = this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener());
            uploadUri = EueUploadHelper.updateResource(this.session, resourceId, status, UploadType.CHUNKED).getUploadURI();
        } else {
            ResourceCreationResponseEntry resourceCreationResponseEntry = EueUploadHelper.createResource(this.session, this.fileid.getFileId(file.getParent(), (ListProgressListener)new DisabledListProgressListener()), file.getName(), status, UploadType.CHUNKED);
            resourceId = EueResourceIdProvider.getResourceIdFromResourceUri(resourceCreationResponseEntry.getHeaders().getLocation());
            uploadUri = resourceCreationResponseEntry.getEntity().getUploadURI();
        }
        try {
            proxy = new MultipartOutputStream(file, resourceId, uploadUri, status, callback);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ChecksumException(LocaleFactory.localizedString((String)"Checksum failure", (String)"Error"), (Throwable)e);
        }
        return new HttpResponseOutputStream<EueWriteFeature.Chunk>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, Integer.valueOf(new HostPreferences(this.session.getHost()).getInteger("eue.upload.multipart.size"))), (AttributesAdapter)new EueAttributesAdapter(), status){

            public EueWriteFeature.Chunk getStatus() {
                return proxy.getResult();
            }
        };
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        return new SHA256ChecksumCompute();
    }

    public boolean timestamp() {
        return true;
    }

    private final class MultipartOutputStream
    extends OutputStream {
        private final Path file;
        private final String resourceId;
        private final String uploadUri;
        private final TransferStatus overall;
        private final ConnectionCallback callback;
        private final AtomicBoolean close = new AtomicBoolean();
        private final AtomicReference<BackgroundException> canceled = new AtomicReference();
        private final AtomicReference<EueWriteFeature.Chunk> result = new AtomicReference();
        private final MessageDigest messageDigest;
        private Long offset = 0L;

        public MultipartOutputStream(Path file, String resourceId, String uploadUri, TransferStatus status, ConnectionCallback callback) throws NoSuchAlgorithmException {
            this.file = file;
            this.resourceId = resourceId;
            this.uploadUri = uploadUri;
            this.overall = status;
            this.callback = callback;
            this.messageDigest = MessageDigest.getInstance("SHA-256");
        }

        @Override
        public void write(int value) throws IOException {
            throw new IOException(new UnsupportedOperationException());
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                if (null != this.canceled.get()) {
                    throw this.canceled.get();
                }
                final byte[] content = Arrays.copyOfRange(b, off, len);
                if (0L == this.offset && (long)content.length < new HostPreferences(EueMultipartWriteFeature.this.session.getHost()).getLong("eue.upload.multipart.threshold")) {
                    EueWriteFeature writer = new EueWriteFeature(EueMultipartWriteFeature.this.session, EueMultipartWriteFeature.this.fileid);
                    log.warn(String.format("Cancel chunked upload for %s", this.file));
                    writer.cancel(this.uploadUri);
                    TransferStatus status = new TransferStatus(this.overall).withLength((long)content.length);
                    HttpResponseOutputStream<EueWriteFeature.Chunk> stream = writer.write(this.file, status.withChecksum(writer.checksum(this.file, this.overall).compute((InputStream)new ByteArrayInputStream(content), status)), this.callback);
                    stream.write(content);
                    stream.close();
                    this.result.set((EueWriteFeature.Chunk)stream.getStatus());
                } else {
                    new DefaultRetryCallable(EueMultipartWriteFeature.this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<EueUploadHelper.UploadResponse>(){

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public EueUploadHelper.UploadResponse call() throws BackgroundException {
                            CloseableHttpClient client = (CloseableHttpClient)EueMultipartWriteFeature.this.session.getClient();
                            try {
                                String hash = new SHA256ChecksumCompute().compute((InputStream)new ByteArrayInputStream((byte[])content), (TransferStatus)new TransferStatus()).hash;
                                MultipartOutputStream.this.messageDigest.update(Hex.decodeHex((String)hash));
                                MultipartOutputStream.this.messageDigest.update(ChunkListSHA256ChecksumCompute.intToBytes(content.length));
                                HttpPut request = new HttpPut(String.format("%s&x_offset=%d&x_sha256=%s&x_size=%d", MultipartOutputStream.this.uploadUri, MultipartOutputStream.this.offset, hash, content.length));
                                request.setEntity(EntityBuilder.create().setBinary(content).build());
                                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                                try {
                                    switch (response.getStatusLine().getStatusCode()) {
                                        case 200: 
                                        case 201: 
                                        case 204: {
                                            return null;
                                        }
                                        default: {
                                            ApiException failure = new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity()));
                                            throw new EueExceptionMappingService().map("Upload {0} failed", failure, MultipartOutputStream.this.file);
                                        }
                                    }
                                }
                                catch (BackgroundException e) {
                                    MultipartOutputStream.this.canceled.set(e);
                                    throw e;
                                }
                                finally {
                                    EntityUtils.consume((HttpEntity)response.getEntity());
                                }
                            }
                            catch (IOException | DecoderException e) {
                                throw new BackgroundException(e);
                            }
                        }
                    }, (StreamCancelation)this.overall).call();
                    this.offset = this.offset + (long)len;
                }
            }
            catch (BackgroundException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        @Override
        public void close() throws IOException {
            block11: {
                try {
                    if (this.close.get()) {
                        log.warn(String.format("Skip double close of stream %s", this));
                        return;
                    }
                    if (null != this.canceled.get()) {
                        log.warn(String.format("Skip closing with previous failure %s", new Object[]{this.canceled.get()}));
                        return;
                    }
                    if (this.result.get() != null) break block11;
                    if (0L == this.offset) {
                        this.write(new byte[0]);
                        break block11;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Complete chunked upload for %s", this.file));
                    }
                    try {
                        String cdash64 = Base64.encodeBase64URLSafeString((byte[])this.messageDigest.digest());
                        EueUploadHelper.UploadResponse completedUploadResponse = new EueMultipartUploadCompleter(EueMultipartWriteFeature.this.session).getCompletedUploadResponse(this.uploadUri, this.offset, cdash64);
                        this.result.set(new EueWriteFeature.Chunk(this.resourceId, this.offset, cdash64));
                    }
                    catch (BackgroundException e) {
                        throw new IOException(e);
                    }
                }
                finally {
                    this.close.set(true);
                }
            }
        }

        public EueWriteFeature.Chunk getResult() {
            return this.result.get();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MultipartOutputStream{");
            sb.append("file=").append(this.file);
            sb.append(", uploadUri='").append(this.uploadUri).append('\'');
            sb.append(", result=").append(this.result);
            sb.append(", offset=").append(this.offset);
            sb.append('}');
            return sb.toString();
        }
    }
}

