/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.eue.EueExceptionMappingService;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.EueUploadHelper;
import ch.cyberduck.core.eue.io.swagger.client.JSON;
import ch.cyberduck.core.exception.BackgroundException;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class EueMultipartUploadCompleter {
    private final EueSession session;

    public EueMultipartUploadCompleter(EueSession session) {
        this.session = session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EueUploadHelper.UploadResponse getCompletedUploadResponse(String uploadUri, long length, String cdash64) throws BackgroundException {
        try {
            HttpPost request = new HttpPost(uploadUri);
            UploadCompletionRequest uploadCompletionRequest = new UploadCompletionRequest();
            uploadCompletionRequest.setTotalSze(length);
            uploadCompletionRequest.setCdash64(cdash64);
            String requestString = new JSON().getContext(EueUploadHelper.UploadResponse.class).writeValueAsString((Object)uploadCompletionRequest);
            HttpEntity entity = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setText(requestString).build();
            request.setEntity(entity);
            CloseableHttpResponse response = ((CloseableHttpClient)this.session.getClient()).execute((HttpUriRequest)request);
            try {
                switch (response.getStatusLine().getStatusCode()) {
                    case 200: 
                    case 201: {
                        EueUploadHelper.UploadResponse uploadResponse = EueUploadHelper.parseUploadCompletedResponse((HttpResponse)response);
                        return uploadResponse;
                    }
                }
                throw new EueExceptionMappingService().map((HttpResponse)response);
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    private static final class UploadCompletionRequest {
        @JsonProperty(value="cdash64")
        private String cdash64 = null;
        @JsonProperty(value="totalSize")
        private Long totalSze = null;

        private UploadCompletionRequest() {
        }

        public String getCdash64() {
            return this.cdash64;
        }

        public void setCdash64(String cdash64) {
            this.cdash64 = cdash64;
        }

        public Long getTotalSze() {
            return this.totalSze;
        }

        public void setTotalSze(Long totalSze) {
            this.totalSze = totalSze;
        }
    }
}

