/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.eue.EueApiClient;
import ch.cyberduck.core.eue.EueAttributesFinderFeature;
import ch.cyberduck.core.eue.EueExceptionMappingService;
import ch.cyberduck.core.eue.EueResourceIdProvider;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.EueTouchFeature;
import ch.cyberduck.core.eue.EueTrashFeature;
import ch.cyberduck.core.eue.io.swagger.client.ApiException;
import ch.cyberduck.core.eue.io.swagger.client.api.MoveChildrenApi;
import ch.cyberduck.core.eue.io.swagger.client.api.MoveChildrenForAliasApiApi;
import ch.cyberduck.core.eue.io.swagger.client.api.UpdateResourceApi;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceCreationResponseEntryEntity;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceMoveResponseEntries;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceMoveResponseEntry;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceUpdateModel;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceUpdateModelUpdate;
import ch.cyberduck.core.eue.io.swagger.client.model.Uifs;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EueMoveFeature
implements Move {
    private static final Logger log = LogManager.getLogger(EueMoveFeature.class);
    private final EueSession session;
    private final EueResourceIdProvider fileid;

    public EueMoveFeature(EueSession session, EueResourceIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Path move(Path file, Path target, TransferStatus status, Delete.Callback delete, ConnectionCallback callback) throws BackgroundException {
        try {
            EueApiClient client = new EueApiClient(this.session);
            if (status.isExists()) {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Trash file %s to be replaced with %s", target, file));
                }
                new EueTrashFeature(this.session, this.fileid).delete(Collections.singletonMap(target, status), (PasswordCallback)callback, delete);
            }
            String resourceId = this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener());
            if (!file.getParent().equals((Object)target.getParent())) {
                ResourceMoveResponseEntries resourceMoveResponseEntries;
                String parentResourceId = this.fileid.getFileId(target.getParent(), (ListProgressListener)new DisabledListProgressListener());
                switch (parentResourceId) {
                    case "ROOT": 
                    case "TRASH": {
                        resourceMoveResponseEntries = new MoveChildrenForAliasApiApi(client).resourceAliasAliasChildrenMovePost(parentResourceId, Collections.singletonList(String.format("%s/resource/%s", this.session.getBasePath(), resourceId)), null, null, null, "rename", null);
                        break;
                    }
                    default: {
                        resourceMoveResponseEntries = new MoveChildrenApi(client).resourceResourceIdChildrenMovePost(parentResourceId, Collections.singletonList(String.format("%s/resource/%s", this.session.getBasePath(), resourceId)), null, null, null, "rename", null);
                    }
                }
                if (null != resourceMoveResponseEntries) {
                    block15: for (ResourceMoveResponseEntry resourceMoveResponseEntry : resourceMoveResponseEntries.values()) {
                        switch (resourceMoveResponseEntry.getStatusCode()) {
                            case 200: {
                                continue block15;
                            }
                        }
                        log.warn(String.format("Failure %s moving file %s", resourceMoveResponseEntries, file));
                        ResourceCreationResponseEntryEntity entity = resourceMoveResponseEntry.getEntity();
                        if (null == entity) {
                            throw new EueExceptionMappingService().map(new ApiException(resourceMoveResponseEntry.getReason(), null, resourceMoveResponseEntry.getStatusCode(), client.getResponseHeaders()));
                        }
                        throw new EueExceptionMappingService().map(new ApiException(resourceMoveResponseEntry.getEntity().getError(), null, resourceMoveResponseEntry.getStatusCode(), client.getResponseHeaders()));
                    }
                }
            }
            if (!StringUtils.equals((CharSequence)file.getName(), (CharSequence)target.getName())) {
                ResourceUpdateModel resourceUpdateModel = new ResourceUpdateModel();
                ResourceUpdateModelUpdate resourceUpdateModelUpdate = new ResourceUpdateModelUpdate();
                Uifs uifs = new Uifs();
                uifs.setName(target.getName());
                resourceUpdateModelUpdate.setUifs(uifs);
                resourceUpdateModel.setUpdate(resourceUpdateModelUpdate);
                ResourceMoveResponseEntries resourceMoveResponseEntries = new UpdateResourceApi(client).resourceResourceIdPatch(resourceId, resourceUpdateModel, null, null, null);
                if (null != resourceMoveResponseEntries) {
                    block16: for (ResourceMoveResponseEntry resourceMoveResponseEntry : resourceMoveResponseEntries.values()) {
                        switch (resourceMoveResponseEntry.getStatusCode()) {
                            case 201: {
                                continue block16;
                            }
                        }
                        log.warn(String.format("Failure %s renaming file %s", resourceMoveResponseEntry, file));
                        throw new EueExceptionMappingService().map(new ApiException(resourceMoveResponseEntry.getReason(), null, resourceMoveResponseEntry.getStatusCode(), client.getResponseHeaders()));
                    }
                }
            }
            this.fileid.cache(file, null);
            return target.withAttributes(new EueAttributesFinderFeature(this.session, this.fileid).find(target, (ListProgressListener)new DisabledListProgressListener()));
        }
        catch (ApiException e) {
            throw new EueExceptionMappingService().map("Cannot rename {0}", e, file);
        }
    }

    public boolean isSupported(Path source, Path target) {
        if (StringUtils.equals((CharSequence)"TRASH", (CharSequence)source.attributes().getFileId())) {
            return false;
        }
        if (StringUtils.equals((CharSequence)this.session.getHost().getProperty("cryptomator.vault.name.default"), (CharSequence)source.getName())) {
            return false;
        }
        return new EueTouchFeature(this.session, this.fileid).isSupported(target.getParent(), target.getName());
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }
}

