/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.eue.EueApiClient;
import ch.cyberduck.core.eue.EueAttributesFinderFeature;
import ch.cyberduck.core.eue.EueExceptionMappingService;
import ch.cyberduck.core.eue.EueResourceIdProvider;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.EueShareFeature;
import ch.cyberduck.core.eue.io.swagger.client.ApiException;
import ch.cyberduck.core.eue.io.swagger.client.api.ListResourceAliasApi;
import ch.cyberduck.core.eue.io.swagger.client.api.ListResourceApi;
import ch.cyberduck.core.eue.io.swagger.client.model.Children;
import ch.cyberduck.core.eue.io.swagger.client.model.UiFsModel;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.HostPreferences;
import java.util.Collections;
import java.util.EnumSet;

public class EueListService
implements ListService {
    private final EueSession session;
    private final EueAttributesFinderFeature attributes;
    private final EueResourceIdProvider fileid;

    public EueListService(EueSession session, EueResourceIdProvider fileid) {
        this.session = session;
        this.attributes = new EueAttributesFinderFeature(session, fileid);
        this.fileid = fileid;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        return this.list(directory, listener, new HostPreferences(this.session.getHost()).getInteger("eue.listing.chunksize"));
    }

    protected AttributedList<Path> list(Path directory, ListProgressListener listener, int chunksize) throws BackgroundException {
        AttributedList children = new AttributedList();
        EueApiClient client = new EueApiClient(this.session);
        try {
            UiFsModel fsModel;
            int offset = 0;
            do {
                String resourceId = this.fileid.getFileId(directory, listener);
                switch (resourceId) {
                    case "ROOT": 
                    case "TRASH": {
                        fsModel = new ListResourceAliasApi(client).resourceAliasAliasGet(resourceId, null, null, null, null, chunksize, offset, Collections.singletonList("win32props"), null);
                        break;
                    }
                    default: {
                        fsModel = new ListResourceApi(client).resourceResourceIdGet(resourceId, null, null, null, null, chunksize, offset, Collections.singletonList("win32props"), null);
                    }
                }
                for (Children child : fsModel.getUifs().getChildren()) {
                    EnumSet<AbstractPath.Type> type;
                    switch (child.getUifs().getResourceType()) {
                        case "aliascontainer": {
                            type = EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder);
                            break;
                        }
                        case "container": {
                            type = EnumSet.of(AbstractPath.Type.directory);
                            break;
                        }
                        default: {
                            type = EnumSet.of(AbstractPath.Type.file);
                        }
                    }
                    children.add((Referenceable)new Path(directory, child.getUifs().getName(), type, this.attributes.toAttributes(child.getUifs(), child.getUiwin32(), EueShareFeature.findShareForResource(this.session.userShares(), EueResourceIdProvider.getResourceIdFromResourceUri(child.getUifs().getResourceURI())))));
                    listener.chunk(directory, children);
                }
                offset += chunksize;
            } while (fsModel.getUifs().getChildren().size() == chunksize);
            return children;
        }
        catch (ApiException e) {
            throw new EueExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }
}

