/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.BytecountStreamListener;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.eue.ChunkListSHA256ChecksumCompute;
import ch.cyberduck.core.eue.EueAttributesAdapter;
import ch.cyberduck.core.eue.EueMultipartUploadCompleter;
import ch.cyberduck.core.eue.EueResourceIdProvider;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.EueUploadHelper;
import ch.cyberduck.core.eue.EueWriteFeature;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceCreationResponseEntry;
import ch.cyberduck.core.eue.io.swagger.client.model.UploadType;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.cyberduck.core.transfer.SegmentRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EueLargeUploadService
extends HttpUploadFeature<EueWriteFeature.Chunk, MessageDigest> {
    private static final Logger log = LogManager.getLogger(EueLargeUploadService.class);
    private final EueSession session;
    private final Long chunksize;
    private final Integer concurrency;
    private final EueResourceIdProvider fileid;
    private Write<EueWriteFeature.Chunk> writer;

    public EueLargeUploadService(EueSession session, EueResourceIdProvider fileid, Write<EueWriteFeature.Chunk> writer) {
        this(session, fileid, writer, new HostPreferences(session.getHost()).getLong("eue.upload.multipart.size"), new HostPreferences(session.getHost()).getInteger("eue.upload.multipart.concurrency"));
    }

    public EueLargeUploadService(EueSession session, EueResourceIdProvider fileid, Write<EueWriteFeature.Chunk> writer, Long chunksize, Integer concurrency) {
        super(writer);
        this.session = session;
        this.writer = writer;
        this.chunksize = chunksize;
        this.concurrency = concurrency;
        this.fileid = fileid;
    }

    public EueWriteFeature.Chunk upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        ThreadPool pool = ThreadPoolFactory.get((String)"multipart", (int)this.concurrency);
        try {
            String uploadUri;
            String resourceId;
            ArrayList<Future<EueWriteFeature.Chunk>> parts = new ArrayList<Future<EueWriteFeature.Chunk>>();
            long offset = 0L;
            long remaining = status.getLength();
            if (status.isExists()) {
                resourceId = this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener());
                uploadUri = EueUploadHelper.updateResource(this.session, resourceId, status, UploadType.CHUNKED).getUploadURI();
            } else {
                ResourceCreationResponseEntry uploadResourceCreationResponseEntry = EueUploadHelper.createResource(this.session, this.fileid.getFileId(file.getParent(), (ListProgressListener)new DisabledListProgressListener()), file.getName(), status, UploadType.CHUNKED);
                resourceId = EueResourceIdProvider.getResourceIdFromResourceUri(uploadResourceCreationResponseEntry.getHeaders().getLocation());
                uploadUri = uploadResourceCreationResponseEntry.getEntity().getUploadURI();
            }
            int partNumber = 1;
            while (remaining > 0L) {
                long length = Math.min(this.chunksize, remaining);
                parts.add(this.submit(pool, file, local, throttle, listener, status, uploadUri, resourceId, partNumber, offset, length, callback));
                remaining -= length;
                offset += length;
                ++partNumber;
            }
            ArrayList<EueWriteFeature.Chunk> chunks = new ArrayList<EueWriteFeature.Chunk>();
            for (Future future : parts) {
                try {
                    chunks.add((EueWriteFeature.Chunk)Uninterruptibles.getUninterruptibly((Future)future));
                }
                catch (ExecutionException e) {
                    log.warn(String.format("Part upload failed with execution failure %s", e.getMessage()));
                    Throwables.throwIfInstanceOf((Throwable)Throwables.getRootCause((Throwable)e), BackgroundException.class);
                    throw new DefaultExceptionMappingService().map(Throwables.getRootCause((Throwable)e));
                }
            }
            long size = status.getOffset() + status.getLength();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            chunks.stream().sorted(Comparator.comparing(EueWriteFeature.Chunk::getPartnumber)).forEach(chunk -> {
                try {
                    messageDigest.update(Hex.decodeHex((String)chunk.getChecksum().hash));
                }
                catch (DecoderException e) {
                    log.error(String.format("Failure %s decoding hash %s", new Object[]{e, chunk.getChecksum()}));
                }
                messageDigest.update(ChunkListSHA256ChecksumCompute.intToBytes(chunk.getLength().intValue()));
            });
            String cdash64 = Base64.encodeBase64URLSafeString((byte[])messageDigest.digest());
            EueUploadHelper.UploadResponse completedUploadResponse = new EueMultipartUploadCompleter(this.session).getCompletedUploadResponse(uploadUri, size, cdash64);
            EueWriteFeature.Chunk object = new EueWriteFeature.Chunk(resourceId, size, cdash64);
            status.withResponse(new EueAttributesAdapter().toAttributes(object)).setComplete();
            EueWriteFeature.Chunk chunk2 = object;
            return chunk2;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ChecksumException(LocaleFactory.localizedString((String)"Checksum failure", (String)"Error"), (Throwable)e);
        }
        finally {
            pool.shutdown(false);
        }
    }

    private Future<EueWriteFeature.Chunk> submit(ThreadPool pool, final Path file, final Local local, final BandwidthThrottle throttle, final StreamListener listener, final TransferStatus overall, final String url, final String resourceId, final int partNumber, final long offset, final long length, final ConnectionCallback callback) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Submit %s to queue with offset %d and length %d", file, offset, length));
        }
        BytecountStreamListener counter = new BytecountStreamListener(listener);
        return pool.execute((Callable)new SegmentRetryCallable(this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<EueWriteFeature.Chunk>(){

            public EueWriteFeature.Chunk call() throws BackgroundException {
                overall.validate();
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("resourceId", resourceId);
                TransferStatus status = new TransferStatus().segment(true).withOffset(offset).withLength(length).withParameters(parameters);
                status.setPart(Integer.valueOf(partNumber));
                status.setHeader(overall.getHeader());
                status.setChecksum(EueLargeUploadService.this.writer.checksum(file, status).compute(local.getInputStream(), status));
                status.setUrl(url);
                EueWriteFeature.Chunk chunk = (EueWriteFeature.Chunk)EueLargeUploadService.this.upload(file, local, throttle, listener, status, (StreamCancelation)overall, (StreamProgress)status, callback);
                if (log.isInfoEnabled()) {
                    log.info(String.format("Received response %s for part %d", chunk, partNumber));
                }
                return chunk;
            }
        }, (StreamCancelation)overall, counter));
    }

    public Upload<EueWriteFeature.Chunk> withWriter(Write<EueWriteFeature.Chunk> writer) {
        this.writer = writer;
        return super.withWriter(writer);
    }
}

