/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DefaultSocketExceptionMappingService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.eue.io.swagger.client.ApiException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LockedException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import java.io.IOException;
import java.net.SocketException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.ProcessingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EueExceptionMappingService
extends AbstractExceptionMappingService<ApiException> {
    private static final Logger log = LogManager.getLogger(EueExceptionMappingService.class);

    public BackgroundException map(ApiException failure) {
        StringBuilder buffer = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)failure.getMessage())) {
            for (String s2 : StringUtils.split((String)failure.getMessage(), (String)",")) {
                this.append(buffer, LocaleFactory.localizedString((String)s2, (String)"EUE"));
            }
        }
        if (null != failure.getResponseHeaders()) {
            List headers = failure.getResponseHeaders().entrySet().stream().filter(e -> "X-UI-ENHANCED-STATUS".equalsIgnoreCase((String)e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
            Iterator iterator = headers.iterator();
            while (iterator.hasNext()) {
                List header = (List)iterator.next();
                for (String s3 : header) {
                    this.append(buffer, LocaleFactory.localizedString((String)s3, (String)"EUE"));
                }
            }
        }
        for (Throwable cause : ExceptionUtils.getThrowableList((Throwable)failure)) {
            if (cause instanceof ProcessingException) {
                return new InteroperabilityException(cause.getMessage(), cause);
            }
            if (cause instanceof SocketException) {
                return new DefaultSocketExceptionMappingService().map((SocketException)cause);
            }
            if (cause instanceof HttpResponseException) {
                return new DefaultHttpResponseExceptionMappingService().map((HttpResponseException)cause);
            }
            if (cause instanceof IOException) {
                return new DefaultIOExceptionMappingService().map((IOException)cause);
            }
            if (!(cause instanceof IllegalStateException)) continue;
            return new ConnectionCanceledException(cause);
        }
        switch (failure.getCode()) {
            case 422: {
                return new LockedException(buffer.toString(), (Throwable)failure);
            }
            case 429: {
                Optional<Map.Entry> header = failure.getResponseHeaders().entrySet().stream().filter(e -> "Retry-After".equals(e.getKey())).findAny();
                if (!header.isPresent()) break;
                Optional value = ((List)header.get().getValue()).stream().findAny();
                return (BackgroundException)value.map((? super T s) -> new RetriableAccessDeniedException(buffer.toString(), Duration.ofSeconds(Long.parseLong(s)), (Throwable)failure)).orElseGet(() -> new RetriableAccessDeniedException(buffer.toString(), (Throwable)failure));
            }
        }
        return new DefaultHttpResponseExceptionMappingService().map((Throwable)failure, buffer, failure.getCode());
    }

    public BackgroundException map(HttpResponse response) {
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        for (Header s : response.getAllHeaders()) {
            responseHeaders.put(s.getName(), Collections.singletonList(s.getValue()));
        }
        return this.map(new ApiException(response.getStatusLine().getReasonPhrase(), null, response.getStatusLine().getStatusCode(), responseHeaders));
    }
}

