/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.eue.EueApiClient;
import ch.cyberduck.core.eue.EueAttributesAdapter;
import ch.cyberduck.core.eue.EueExceptionMappingService;
import ch.cyberduck.core.eue.EueResourceIdProvider;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.EueTouchFeature;
import ch.cyberduck.core.eue.EueWriteFeature;
import ch.cyberduck.core.eue.io.swagger.client.ApiException;
import ch.cyberduck.core.eue.io.swagger.client.api.PostChildrenForAliasApi;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceCreationRepresentationArrayInner;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceCreationResponseEntries;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceCreationResponseEntry;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceCreationResponseEntryEntity;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EueDirectoryFeature
implements Directory<EueWriteFeature.Chunk> {
    private static final Logger log = LogManager.getLogger(EueDirectoryFeature.class);
    private final EueSession session;
    private final EueResourceIdProvider fileid;

    public EueDirectoryFeature(EueSession session, EueResourceIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Path mkdir(Path folder, TransferStatus status) throws BackgroundException {
        try {
            ResourceCreationRepresentationArrayInner resourceCreationRepresentation = new ResourceCreationRepresentationArrayInner();
            String path = StringUtils.removeStart((String)folder.getAbsolute(), (String)String.valueOf('/'));
            resourceCreationRepresentation.setPath(path);
            resourceCreationRepresentation.setResourceType(ResourceCreationRepresentationArrayInner.ResourceTypeEnum.CONTAINER);
            EueApiClient client = new EueApiClient(this.session);
            ResourceCreationResponseEntries resourceCreationResponseEntries = new PostChildrenForAliasApi(client).resourceAliasAliasChildrenPost("ROOT", Collections.singletonList(resourceCreationRepresentation), null, null, null, null, null);
            if (!resourceCreationResponseEntries.containsKey(path)) {
                throw new NotfoundException(folder.getAbsolute());
            }
            ResourceCreationResponseEntry resourceCreationResponseEntry = (ResourceCreationResponseEntry)resourceCreationResponseEntries.get(path);
            switch (resourceCreationResponseEntry.getStatusCode()) {
                case 200: {
                    log.warn(String.format("Folder %s already exists", folder));
                }
                case 201: {
                    String resourceId = EueResourceIdProvider.getResourceIdFromResourceUri(resourceCreationResponseEntry.getHeaders().getLocation());
                    this.fileid.cache(folder, resourceId);
                    return folder.withAttributes(new EueAttributesAdapter().toAttributes(new EueWriteFeature.Chunk(resourceId, 0L, null)));
                }
            }
            log.warn(String.format("Failure %s creating folder %s", resourceCreationResponseEntry, folder));
            ResourceCreationResponseEntryEntity entity = resourceCreationResponseEntry.getEntity();
            if (null == entity) {
                throw new EueExceptionMappingService().map(new ApiException(resourceCreationResponseEntry.getReason(), null, resourceCreationResponseEntry.getStatusCode(), client.getResponseHeaders()));
            }
            throw new EueExceptionMappingService().map(new ApiException(resourceCreationResponseEntry.getEntity().getError(), null, resourceCreationResponseEntry.getStatusCode(), client.getResponseHeaders()));
        }
        catch (ApiException e) {
            throw new EueExceptionMappingService().map("Cannot create folder {0}", e, folder);
        }
    }

    public boolean isSupported(Path workdir, String name) {
        return new EueTouchFeature(this.session, this.fileid).isSupported(workdir, name);
    }

    public Directory<EueWriteFeature.Chunk> withWriter(Write<EueWriteFeature.Chunk> writer) {
        return this;
    }
}

