/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.eue.EueApiClient;
import ch.cyberduck.core.eue.EueExceptionMappingService;
import ch.cyberduck.core.eue.EueResourceIdProvider;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.EueTrashFeature;
import ch.cyberduck.core.eue.io.swagger.client.ApiException;
import ch.cyberduck.core.eue.io.swagger.client.api.DeleteResourceApi;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EueDeleteFeature
extends EueTrashFeature
implements Delete {
    private static final Logger log = LogManager.getLogger(EueDeleteFeature.class);
    private final EueSession session;
    private final EueResourceIdProvider fileid;

    public EueDeleteFeature(EueSession session, EueResourceIdProvider fileid) {
        super(session, fileid);
        this.session = session;
        this.fileid = fileid;
    }

    @Override
    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        block3: {
            try {
                EueApiClient client = new EueApiClient(this.session);
                this.delete(super.trash(files, prompt, callback));
                for (Path f : files.keySet()) {
                    this.fileid.cache(f, null);
                }
            }
            catch (ApiException e) {
                Iterator<Path> iterator = files.keySet().iterator();
                if (!iterator.hasNext()) break block3;
                Path f = iterator.next();
                throw new EueExceptionMappingService().map("Cannot delete {0}", e, f);
            }
        }
    }

    protected void delete(List<String> resources) throws ApiException {
        for (String resourceId : resources) {
            new DeleteResourceApi(new EueApiClient(this.session)).resourceResourceIdDelete(resourceId, null, null);
        }
    }

    @Override
    public boolean isSupported(Path file) {
        return !StringUtils.equals((CharSequence)"TRASH", (CharSequence)file.attributes().getFileId()) && !StringUtils.equals((CharSequence)this.session.getHost().getProperty("cryptomator.vault.name.default"), (CharSequence)file.getName());
    }

    @Override
    public boolean isRecursive() {
        return true;
    }
}

