/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.eue.EueApiClient;
import ch.cyberduck.core.eue.EueAttributesFinderFeature;
import ch.cyberduck.core.eue.EueExceptionMappingService;
import ch.cyberduck.core.eue.EueResourceIdProvider;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.EueTouchFeature;
import ch.cyberduck.core.eue.EueTrashFeature;
import ch.cyberduck.core.eue.io.swagger.client.ApiException;
import ch.cyberduck.core.eue.io.swagger.client.api.CopyChildrenApi;
import ch.cyberduck.core.eue.io.swagger.client.api.CopyChildrenForAliasApiApi;
import ch.cyberduck.core.eue.io.swagger.client.api.UpdateResourceApi;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceCopyResponseEntries;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceCopyResponseEntry;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceMoveResponseEntries;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceMoveResponseEntry;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceUpdateModel;
import ch.cyberduck.core.eue.io.swagger.client.model.ResourceUpdateModelUpdate;
import ch.cyberduck.core.eue.io.swagger.client.model.Uifs;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EueCopyFeature
implements Copy {
    private static final Logger log = LogManager.getLogger(EueCopyFeature.class);
    private final EueSession session;
    private final EueResourceIdProvider fileid;

    public EueCopyFeature(EueSession session, EueResourceIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Path copy(Path file, Path target, TransferStatus status, ConnectionCallback callback, StreamListener listener) throws BackgroundException {
        try {
            ResourceCopyResponseEntries resourceCopyResponseEntries;
            EueApiClient client = new EueApiClient(this.session);
            if (status.isExists()) {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Trash file %s to be replaced with %s", target, file));
                }
                new EueTrashFeature(this.session, this.fileid).delete(Collections.singletonMap(target, status), (PasswordCallback)callback, (Delete.Callback)new Delete.DisabledCallback());
            }
            String resourceId = this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener());
            String parentResourceId = this.fileid.getFileId(target.getParent(), (ListProgressListener)new DisabledListProgressListener());
            Object targetResourceId = null;
            switch (parentResourceId) {
                case "ROOT": 
                case "TRASH": {
                    resourceCopyResponseEntries = new CopyChildrenForAliasApiApi(client).resourceAliasAliasChildrenCopyPost(parentResourceId, Collections.singletonList(String.format("%s/resource/%s", this.session.getBasePath(), resourceId)), null, null, null, "rename", null);
                    break;
                }
                default: {
                    resourceCopyResponseEntries = new CopyChildrenApi(client).resourceResourceIdChildrenCopyPost(parentResourceId, Collections.singletonList(String.format("%s/resource/%s", this.session.getBasePath(), resourceId)), null, null, null, "rename", null);
                }
            }
            if (null != resourceCopyResponseEntries) {
                block15: for (ResourceCopyResponseEntry resourceCopyResponseEntry : resourceCopyResponseEntries.values()) {
                    switch (resourceCopyResponseEntry.getStatusCode()) {
                        case 201: {
                            this.fileid.cache(target, EueResourceIdProvider.getResourceIdFromResourceUri(resourceCopyResponseEntry.getHeaders().getLocation()));
                            continue block15;
                        }
                    }
                    log.warn(String.format("Failure %s copying file %s", resourceCopyResponseEntries, file));
                    throw new EueExceptionMappingService().map(new ApiException(resourceCopyResponseEntry.getReason(), null, resourceCopyResponseEntry.getStatusCode(), client.getResponseHeaders()));
                }
            }
            listener.sent(status.getLength());
            if (!StringUtils.equals((CharSequence)file.getName(), (CharSequence)target.getName())) {
                ResourceUpdateModel resourceUpdateModel = new ResourceUpdateModel();
                ResourceUpdateModelUpdate resourceUpdateModelUpdate = new ResourceUpdateModelUpdate();
                Uifs uifs = new Uifs();
                uifs.setName(target.getName());
                resourceUpdateModelUpdate.setUifs(uifs);
                resourceUpdateModel.setUpdate(resourceUpdateModelUpdate);
                ResourceMoveResponseEntries resourceMoveResponseEntries = new UpdateResourceApi(client).resourceResourceIdPatch(this.fileid.getFileId(target, (ListProgressListener)new DisabledListProgressListener()), resourceUpdateModel, null, null, null);
                if (null != resourceMoveResponseEntries) {
                    block16: for (ResourceMoveResponseEntry resourceMoveResponseEntry : resourceMoveResponseEntries.values()) {
                        switch (resourceMoveResponseEntry.getStatusCode()) {
                            case 201: {
                                continue block16;
                            }
                        }
                        log.warn(String.format("Failure %s renaming file %s", resourceMoveResponseEntry, file));
                        throw new EueExceptionMappingService().map(new ApiException(resourceMoveResponseEntry.getReason(), null, resourceMoveResponseEntry.getStatusCode(), client.getResponseHeaders()));
                    }
                }
            }
            return target.withAttributes(new EueAttributesFinderFeature(this.session, this.fileid).find(target, (ListProgressListener)new DisabledListProgressListener()));
        }
        catch (ApiException e) {
            throw new EueExceptionMappingService().map("Cannot copy {0}", e, file);
        }
    }

    public boolean isSupported(Path source, Path target) {
        return new EueTouchFeature(this.session, this.fileid).isSupported(target.getParent(), target.getName());
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }
}

