/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.eue.EueApiClient;
import ch.cyberduck.core.eue.EueExceptionMappingService;
import ch.cyberduck.core.eue.EueResourceIdProvider;
import ch.cyberduck.core.eue.EueSession;
import ch.cyberduck.core.eue.EueShareFeature;
import ch.cyberduck.core.eue.EueShareUrlProvider;
import ch.cyberduck.core.eue.io.swagger.client.ApiException;
import ch.cyberduck.core.eue.io.swagger.client.api.ListResourceAliasApi;
import ch.cyberduck.core.eue.io.swagger.client.api.ListResourceApi;
import ch.cyberduck.core.eue.io.swagger.client.model.ShareCreationResponseEntity;
import ch.cyberduck.core.eue.io.swagger.client.model.UiFsModel;
import ch.cyberduck.core.eue.io.swagger.client.model.UiWin32;
import ch.cyberduck.core.eue.io.swagger.client.model.Uifs;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EueAttributesFinderFeature
implements AttributesFinder {
    private static final Logger log = LogManager.getLogger(EueAttributesFinderFeature.class);
    protected static final String OPTION_WIN_32_PROPS = "win32props";
    protected static final String OPTION_SHARES = "shares";
    protected static final String OPTION_DOWNLOAD = "download";
    private final EueSession session;
    private final EueResourceIdProvider fileid;

    public EueAttributesFinderFeature(EueSession session, EueResourceIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public PathAttributes find(Path file, ListProgressListener listener) throws BackgroundException {
        try {
            UiFsModel response;
            String resourceId;
            EueApiClient client = new EueApiClient(this.session);
            switch (resourceId = this.fileid.getFileId(file, listener)) {
                case "ROOT": 
                case "TRASH": {
                    response = new ListResourceAliasApi(client).resourceAliasAliasGet(resourceId, null, file.attributes().getETag(), null, null, null, null, Collections.singletonList(OPTION_WIN_32_PROPS), null);
                    break;
                }
                default: {
                    response = new ListResourceApi(client).resourceResourceIdGet(resourceId, null, file.attributes().getETag(), null, null, null, null, Collections.singletonList(OPTION_WIN_32_PROPS), null);
                }
            }
            switch (response.getUifs().getResourceType()) {
                case "aliascontainer": 
                case "container": {
                    if (!file.isFile()) break;
                    throw new NotfoundException(file.getAbsolute());
                }
                default: {
                    if (!file.isDirectory()) break;
                    throw new NotfoundException(file.getAbsolute());
                }
            }
            PathAttributes attr = this.toAttributes(response.getUifs(), response.getUiwin32(), EueShareFeature.findShareForResource(this.session.userShares(), resourceId));
            if (client.getResponseHeaders().containsKey("ETag")) {
                attr.setETag(StringUtils.remove((String)client.getResponseHeaders().get("ETag").stream().findFirst().orElse(null), (char)'\"'));
            }
            return attr;
        }
        catch (ApiException e) {
            switch (e.getCode()) {
                case 304: {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("No changes for file %s with ETag %s", file, file.attributes().getETag()));
                    }
                    return file.attributes();
                }
            }
            throw new EueExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    protected PathAttributes toAttributes(Uifs entity, UiWin32 uiwin32, ShareCreationResponseEntity share) {
        PathAttributes attr = new PathAttributes();
        attr.setDisplayname(entity.getName());
        attr.setETag(StringUtils.remove((String)entity.getMetaETag(), (char)'\"'));
        if (entity.getVersion() != null) {
            attr.setRevision(Long.valueOf(entity.getVersion().intValue()));
        }
        attr.setSize(entity.getSize().longValue());
        String resourceId = EueResourceIdProvider.getResourceIdFromResourceUri(entity.getResourceURI());
        attr.setFileId(resourceId);
        if (null == uiwin32) {
            log.warn("Missing extended properties");
            return attr;
        }
        attr.setCreationDate(uiwin32.getCreationMillis().longValue());
        attr.setModificationDate(uiwin32.getLastModificationMillis().longValue());
        attr.setAccessedDate(uiwin32.getLastAccessMillis().longValue());
        attr.setHidden(uiwin32.isHidden().booleanValue());
        attr.setLink(EueShareUrlProvider.toUrl(this.session.getHost(), share));
        return attr;
    }
}

