/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eue;

import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.io.AbstractChecksumCompute;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;

public class ChunkListSHA256ChecksumCompute
extends AbstractChecksumCompute {
    public static byte[] intToBytes(int i) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(i);
        return bb.array();
    }

    public Checksum compute(InputStream in, TransferStatus status) throws BackgroundException {
        return this.compute(status.getLength(), super.digest("SHA-256", this.normalize(in, status), (StreamCancelation)status));
    }

    public Checksum compute(Number length, byte[] contentDigest) throws ChecksumException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ChecksumException(e.getMessage(), (Throwable)e);
        }
        digest.update(contentDigest);
        digest.update(ChunkListSHA256ChecksumCompute.intToBytes(length.intValue()));
        return new Checksum(HashAlgorithm.cdash64, Base64.encodeBase64URLSafeString((byte[])digest.digest()));
    }
}

