/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2AttributesFinderFeature;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2LargeUploadPartService;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2VersionIdProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2FileInfoResponse;
import synapticloop.b2.response.B2FileResponse;
import synapticloop.b2.response.B2GetUploadPartUrlResponse;
import synapticloop.b2.response.B2GetUploadUrlResponse;
import synapticloop.b2.response.B2UploadPartResponse;
import synapticloop.b2.response.BaseB2Response;

public class B2WriteFeature
extends AbstractHttpWriteFeature<BaseB2Response>
implements Write<BaseB2Response> {
    private static final Logger log = LogManager.getLogger(B2WriteFeature.class);
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;
    private final B2VersionIdProvider fileid;
    private final ThreadLocal<B2GetUploadUrlResponse> urls = new ThreadLocal();

    public B2WriteFeature(B2Session session, B2VersionIdProvider fileid) {
        super((AttributesAdapter)new B2AttributesFinderFeature(session, fileid));
        this.session = session;
        this.fileid = fileid;
    }

    public HttpResponseOutputStream<BaseB2Response> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        DelayedHttpEntityCallable<BaseB2Response> command = new DelayedHttpEntityCallable<BaseB2Response>(){

            public BaseB2Response call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    Checksum checksum = status.getChecksum();
                    if (status.isSegment()) {
                        B2GetUploadPartUrlResponse uploadUrl = ((B2ApiClient)B2WriteFeature.this.session.getClient()).getUploadPartUrl((String)status.getParameters().get("fileId"));
                        return ((B2ApiClient)B2WriteFeature.this.session.getClient()).uploadLargeFilePart(uploadUrl, status.getPart().intValue(), (HttpEntity)entity, checksum.hash);
                    }
                    if (null == B2WriteFeature.this.urls.get()) {
                        B2GetUploadUrlResponse uploadUrl = ((B2ApiClient)B2WriteFeature.this.session.getClient()).getUploadUrl(B2WriteFeature.this.fileid.getVersionId(B2WriteFeature.this.containerService.getContainer(file), (ListProgressListener)new DisabledListProgressListener()));
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Obtained upload URL %s for file %s", uploadUrl, file));
                        }
                        B2WriteFeature.this.urls.set(uploadUrl);
                        return this.upload(uploadUrl, entity, checksum);
                    }
                    B2GetUploadUrlResponse uploadUrl = (B2GetUploadUrlResponse)B2WriteFeature.this.urls.get();
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Use cached upload URL %s for file %s", uploadUrl, file));
                    }
                    try {
                        return this.upload(uploadUrl, entity, checksum);
                    }
                    catch (IOException | B2ApiException e) {
                        log.warn(String.format("Remove cached upload URL after failure %s", e));
                        B2WriteFeature.this.urls.remove();
                        return this.upload(uploadUrl, entity, checksum);
                    }
                }
                catch (B2ApiException e) {
                    throw new B2ExceptionMappingService(B2WriteFeature.this.fileid).map("Upload {0} failed", e, file);
                }
                catch (IOException e) {
                    throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
                }
            }

            private BaseB2Response upload(B2GetUploadUrlResponse uploadUrl, AbstractHttpEntity entity, Checksum checksum) throws B2ApiException, IOException {
                HashMap<String, String> fileinfo = new HashMap<String, String>(status.getMetadata());
                if (null != status.getTimestamp()) {
                    fileinfo.put("src_last_modified_millis", String.valueOf(status.getTimestamp()));
                }
                B2FileResponse response = ((B2ApiClient)B2WriteFeature.this.session.getClient()).uploadFile(uploadUrl, B2WriteFeature.this.containerService.getKey(file), (HttpEntity)entity, checksum.algorithm == HashAlgorithm.sha1 ? checksum.hash : "do_not_verify", status.getMime(), fileinfo);
                B2WriteFeature.this.fileid.cache(file, response.getFileId());
                return response;
            }

            public long getContentLength() {
                return status.getLength();
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }

    public boolean timestamp() {
        return true;
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        return ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.sha1);
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        B2LargeUploadPartService partService = new B2LargeUploadPartService(this.session, this.fileid);
        List<B2FileInfoResponse> upload = partService.find(file);
        if (!upload.isEmpty()) {
            Long size = 0L;
            for (B2UploadPartResponse completed : partService.list(upload.iterator().next().getFileId())) {
                size = size + completed.getContentLength();
            }
            return new Write.Append(true).withStatus(status).withSize(size);
        }
        return new Write.Append(false).withStatus(status);
    }
}

