/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.b2.B2CopyFeature;
import ch.cyberduck.core.b2.B2LifecycleFeature;
import ch.cyberduck.core.b2.B2ObjectListService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2VersionIdProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.io.DisabledStreamListener;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.lifecycle.LifecycleConfiguration;
import ch.cyberduck.core.transfer.TransferStatus;

public class B2VersioningFeature
implements Versioning {
    private final B2Session session;
    private final B2VersionIdProvider fileid;

    public B2VersioningFeature(B2Session session, B2VersionIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public VersioningConfiguration getConfiguration(Path container) throws BackgroundException {
        LifecycleConfiguration configuration = new B2LifecycleFeature(this.session, this.fileid).getConfiguration(container);
        if (configuration.getTransition() == null && configuration.getExpiration() != null && configuration.getExpiration() == 1) {
            return new VersioningConfiguration(false);
        }
        return new VersioningConfiguration(true);
    }

    public void setConfiguration(Path container, PasswordCallback prompt, VersioningConfiguration configuration) throws BackgroundException {
        if (configuration.isEnabled()) {
            new B2LifecycleFeature(this.session, this.fileid).setConfiguration(container, LifecycleConfiguration.empty());
        } else {
            new B2LifecycleFeature(this.session, this.fileid).setConfiguration(container, new LifecycleConfiguration(null, Integer.valueOf(1)));
        }
    }

    public void revert(Path file) throws BackgroundException {
        new B2CopyFeature(this.session, this.fileid).copy(file, file, new TransferStatus(), (ConnectionCallback)new DisabledLoginCallback(), (StreamListener)new DisabledStreamListener());
    }

    public boolean isRevertable(Path file) {
        return true;
    }

    public AttributedList<Path> list(Path file, ListProgressListener listener) throws BackgroundException {
        return new B2ObjectListService(this.session, this.fileid).list(file, listener).filter((Filter)new NullFilter<Path>(){

            public boolean accept(Path f) {
                return f.attributes().isDuplicate();
            }
        });
    }
}

