/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.CachingVersionIdProvider;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.VersionIdProvider;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2BucketResponse;
import synapticloop.b2.response.B2FileInfoResponse;
import synapticloop.b2.response.B2ListFilesResponse;

public class B2VersionIdProvider
extends CachingVersionIdProvider
implements VersionIdProvider {
    private static final Logger log = LogManager.getLogger(B2VersionIdProvider.class);
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;

    public B2VersionIdProvider(B2Session session) {
        super(session.getCaseSensitivity());
        this.session = session;
    }

    public String getVersionId(Path file, ListProgressListener listener) throws BackgroundException {
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Return version %s from attributes for file %s", file.attributes().getVersionId(), file));
            }
            return file.attributes().getVersionId();
        }
        String cached = super.getVersionId(file, listener);
        if (cached != null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Return cached versionid %s for file %s", cached, file));
            }
            return cached;
        }
        try {
            if (this.containerService.isContainer(file)) {
                B2BucketResponse info = ((B2ApiClient)this.session.getClient()).listBucket(file.getName());
                if (null == info) {
                    throw new NotfoundException(file.getAbsolute());
                }
                return this.cache(file, info.getBucketId());
            }
            B2ListFilesResponse response = ((B2ApiClient)this.session.getClient()).listFileNames(this.getVersionId(this.containerService.getContainer(file), listener), this.containerService.getKey(file), Integer.valueOf(1));
            for (B2FileInfoResponse info : response.getFiles()) {
                if (!StringUtils.equals((CharSequence)this.containerService.getKey(file), (CharSequence)info.getFileName())) continue;
                return this.cache(file, info.getFileId());
            }
            throw new NotfoundException(file.getAbsolute());
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService(this).map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }
}

