/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.b2.B2LargeUploadService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2SingleUploadService;
import ch.cyberduck.core.b2.B2VersionIdProvider;
import ch.cyberduck.core.b2.B2WriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import synapticloop.b2.response.BaseB2Response;

public class B2ThresholdUploadService
implements Upload<BaseB2Response> {
    private static final Logger log = LogManager.getLogger(B2ThresholdUploadService.class);
    private final B2Session session;
    private final B2VersionIdProvider fileid;
    private Write<BaseB2Response> writer;
    private final Long threshold;

    public B2ThresholdUploadService(B2Session session, B2VersionIdProvider fileid) {
        this(session, fileid, new HostPreferences(session.getHost()).getLong("b2.upload.largeobject.threshold"));
    }

    public B2ThresholdUploadService(B2Session session, B2VersionIdProvider fileid, Long threshold) {
        this.session = session;
        this.fileid = fileid;
        this.writer = new B2WriteFeature(session, fileid);
        this.threshold = threshold;
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return this.writer.append(file, status);
    }

    public BaseB2Response upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        if (this.threshold(status.getLength())) {
            return new B2LargeUploadService(this.session, this.fileid, this.writer).upload(file, local, throttle, listener, status, callback);
        }
        return (BaseB2Response)new B2SingleUploadService(this.session, this.writer).upload(file, local, throttle, listener, status, callback);
    }

    public Upload<BaseB2Response> withWriter(Write<BaseB2Response> writer) {
        this.writer = writer;
        return this;
    }

    protected boolean threshold(Long length) {
        if (length > this.threshold) {
            if (!new HostPreferences(this.session.getHost()).getBoolean("b2.upload.largeobject") && length < new HostPreferences(this.session.getHost()).getLong("b2.upload.largeobject.required.threshold")) {
                log.warn("Large upload is disabled with property b2.upload.largeobject.required.threshold");
                return false;
            }
            return true;
        }
        return false;
    }
}

