/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.b2.B2CopyFeature;
import ch.cyberduck.core.b2.B2LargeCopyFeature;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2ThresholdUploadService;
import ch.cyberduck.core.b2.B2VersionIdProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class B2ThresholdCopyFeature
implements Copy {
    private static final Logger log = LogManager.getLogger(B2ThresholdCopyFeature.class);
    private final B2Session session;
    private final B2VersionIdProvider fileid;
    private final Long threshold;

    public B2ThresholdCopyFeature(B2Session session, B2VersionIdProvider fileid) {
        this(session, fileid, new HostPreferences(session.getHost()).getLong("b2.copy.largeobject.threshold"));
    }

    public B2ThresholdCopyFeature(B2Session session, B2VersionIdProvider fileid, Long threshold) {
        this.session = session;
        this.fileid = fileid;
        this.threshold = threshold;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback, StreamListener listener) throws BackgroundException {
        if (new B2ThresholdUploadService(this.session, this.fileid, this.threshold).threshold(status.getLength())) {
            return new B2LargeCopyFeature(this.session, this.fileid).copy(source, target, status, callback, listener);
        }
        return new B2CopyFeature(this.session, this.fileid).copy(source, target, status, callback, listener);
    }

    public boolean isSupported(Path source, Path target) {
        return new B2CopyFeature(this.session, this.fileid).isSupported(source, target);
    }

    public boolean isRecursive(Path source, Path target) {
        return new B2CopyFeature(this.session, this.fileid).isRecursive(source, target);
    }
}

