/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.preferences.HostPreferences;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import synapticloop.b2.response.B2FileResponse;
import synapticloop.b2.response.BaseB2Response;

public class B2SingleUploadService
extends HttpUploadFeature<BaseB2Response, MessageDigest> {
    private static final Logger log = LogManager.getLogger(B2SingleUploadService.class);
    private final B2Session session;
    private Write<BaseB2Response> writer;

    public B2SingleUploadService(B2Session session, Write<BaseB2Response> writer) {
        super(writer);
        this.session = session;
        this.writer = writer;
    }

    protected InputStream decorate(InputStream in, MessageDigest digest) throws IOException {
        if (null == digest) {
            return super.decorate(in, null);
        }
        return new DigestInputStream(in, digest);
    }

    protected MessageDigest digest() throws IOException {
        MessageDigest digest = null;
        if (new HostPreferences(this.session.getHost()).getBoolean("b2.upload.checksum.verify")) {
            try {
                digest = MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return digest;
    }

    protected void post(Path file, MessageDigest digest, BaseB2Response response) throws BackgroundException {
        this.verify(file, digest, Checksum.parse((String)StringUtils.removeStart((String)((B2FileResponse)response).getContentSha1(), (String)"unverified:")));
    }

    public Upload<BaseB2Response> withWriter(Write<BaseB2Response> writer) {
        this.writer = writer;
        return super.withWriter(writer);
    }
}

