/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.b2.B2AttributesFinderFeature;
import ch.cyberduck.core.b2.B2AuthorizedUrlProvider;
import ch.cyberduck.core.b2.B2BucketTypeFeature;
import ch.cyberduck.core.b2.B2DeleteFeature;
import ch.cyberduck.core.b2.B2DirectoryFeature;
import ch.cyberduck.core.b2.B2ErrorResponseInterceptor;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FindFeature;
import ch.cyberduck.core.b2.B2LargeUploadWriteFeature;
import ch.cyberduck.core.b2.B2LifecycleFeature;
import ch.cyberduck.core.b2.B2ListService;
import ch.cyberduck.core.b2.B2MetadataFeature;
import ch.cyberduck.core.b2.B2MoveFeature;
import ch.cyberduck.core.b2.B2ReadFeature;
import ch.cyberduck.core.b2.B2SearchFeature;
import ch.cyberduck.core.b2.B2ThresholdCopyFeature;
import ch.cyberduck.core.b2.B2ThresholdUploadService;
import ch.cyberduck.core.b2.B2TouchFeature;
import ch.cyberduck.core.b2.B2UrlProvider;
import ch.cyberduck.core.b2.B2VersionIdProvider;
import ch.cyberduck.core.b2.B2VersioningFeature;
import ch.cyberduck.core.b2.B2WriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Lifecycle;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.features.Metadata;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.VersionIdProvider;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2AuthorizeAccountResponse;

public class B2Session
extends HttpSession<B2ApiClient> {
    private B2ErrorResponseInterceptor retryHandler;
    private final B2VersionIdProvider fileid = new B2VersionIdProvider(this);
    private final B2ListService listService = new B2ListService(this, this.fileid);

    public B2Session(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    protected B2ApiClient connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt, CancelCallback cancel) {
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        this.retryHandler = new B2ErrorResponseInterceptor(this, this.fileid);
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)this.retryHandler);
        configuration.addInterceptorLast((HttpRequestInterceptor)this.retryHandler);
        return new B2ApiClient(configuration.build());
    }

    public void logout() throws BackgroundException {
        try {
            ((B2ApiClient)this.client).close();
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        finally {
            this.fileid.clear();
        }
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        try {
            String accountId = this.host.getCredentials().getUsername();
            String applicationKey = this.host.getCredentials().getPassword();
            B2AuthorizeAccountResponse response = ((B2ApiClient)this.client).authenticate(accountId, applicationKey);
            if (StringUtils.isNotBlank((CharSequence)response.getBucketId())) {
                PathAttributes attributes = new PathAttributes();
                attributes.setVersionId(response.getBucketId());
                this.listService.withBucket(new Path(PathNormalizer.normalize((String)response.getBucketName()), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume), attributes));
            }
            this.retryHandler.setTokens(accountId, applicationKey, response.getAuthorizationToken());
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService(this.fileid).map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)this.listService;
        }
        if (type == Touch.class) {
            return (T)((Object)new B2TouchFeature(this, this.fileid));
        }
        if (type == Read.class) {
            return (T)new B2ReadFeature(this, this.fileid);
        }
        if (type == Upload.class) {
            return (T)new B2ThresholdUploadService(this, this.fileid);
        }
        if (type == MultipartWrite.class) {
            return (T)new B2LargeUploadWriteFeature(this, this.fileid);
        }
        if (type == Write.class) {
            return (T)((Object)new B2WriteFeature(this, this.fileid));
        }
        if (type == Directory.class) {
            return (T)new B2DirectoryFeature(this, this.fileid);
        }
        if (type == Delete.class) {
            return (T)new B2DeleteFeature(this, this.fileid);
        }
        if (type == Copy.class) {
            return (T)new B2ThresholdCopyFeature(this, this.fileid);
        }
        if (type == Move.class) {
            return (T)new B2MoveFeature(this, this.fileid);
        }
        if (type == UrlProvider.class) {
            return (T)new B2UrlProvider(this);
        }
        if (type == PromptUrlProvider.class) {
            return (T)new B2AuthorizedUrlProvider(this, this.fileid);
        }
        if (type == Find.class) {
            return (T)new B2FindFeature(this, this.fileid);
        }
        if (type == AttributesFinder.class) {
            return (T)new B2AttributesFinderFeature(this, this.fileid);
        }
        if (type == AclPermission.class) {
            return (T)((Object)new B2BucketTypeFeature(this, this.fileid));
        }
        if (type == Location.class) {
            return (T)((Object)new B2BucketTypeFeature(this, this.fileid));
        }
        if (type == VersionIdProvider.class) {
            return (T)((Object)this.fileid);
        }
        if (type == Lifecycle.class) {
            return (T)new B2LifecycleFeature(this, this.fileid);
        }
        if (type == Search.class) {
            return (T)new B2SearchFeature(this, this.fileid);
        }
        if (type == Headers.class) {
            return (T)new B2MetadataFeature(this, this.fileid);
        }
        if (type == Metadata.class) {
            return (T)new B2MetadataFeature(this, this.fileid);
        }
        if (type == Versioning.class) {
            return (T)new B2VersioningFeature(this, this.fileid);
        }
        return (T)super._getFeature(type);
    }
}

