/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DefaultPathContainerService;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.b2.B2AttributesFinderFeature;
import ch.cyberduck.core.b2.B2BucketListService;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2VersionIdProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.preferences.HostPreferences;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2FileInfoResponse;
import synapticloop.b2.response.B2ListFilesResponse;

public class B2SearchFeature
implements Search {
    private final PathContainerService containerService = new DefaultPathContainerService();
    private final B2Session session;
    private final B2VersionIdProvider fileid;

    public B2SearchFeature(B2Session session, B2VersionIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public AttributedList<Path> search(Path workdir, Filter<Path> regex, ListProgressListener listener) throws BackgroundException {
        try {
            AttributedList<Path> containers;
            AttributedList list = new AttributedList();
            String prefix = null;
            if (workdir.isRoot()) {
                containers = new B2BucketListService(this.session, this.fileid).list(new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory)), listener);
            } else {
                containers = new AttributedList<Path>(Collections.singletonList(this.containerService.getContainer(workdir)));
                if (!this.containerService.isContainer(workdir)) {
                    prefix = this.containerService.getKey(workdir) + '/';
                }
            }
            for (Path container : containers) {
                B2ListFilesResponse response;
                String startFilename = prefix;
                do {
                    response = ((B2ApiClient)this.session.getClient()).listFileNames(this.fileid.getVersionId(container, listener), startFilename, Integer.valueOf(new HostPreferences(this.session.getHost()).getInteger("b2.listing.chunksize")), prefix, null);
                    for (B2FileInfoResponse info : response.getFiles()) {
                        if (!PathNormalizer.name((String)info.getFileName()).startsWith(regex.toPattern().pattern())) continue;
                        list.add((Referenceable)new Path(String.format("%s%s%s", container.getAbsolute(), Character.valueOf('/'), info.getFileName()), EnumSet.of(AbstractPath.Type.file), new B2AttributesFinderFeature(this.session, this.fileid).toAttributes(info)));
                    }
                } while ((startFilename = response.getNextFileName()) != null);
            }
            return list;
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService(this.fileid).map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public boolean isRecursive() {
        return false;
    }
}

